/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangeExtension;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.VariableAware;
import org.apache.camel.clock.Clock;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.annotations.ConstantProvider;

@ConstantProvider(value="org.apache.camel.ExchangeConstantProvider")
public interface Exchange
extends VariableAware {
    public static final String AUTHENTICATION = "CamelAuthentication";
    public static final String AUTHENTICATION_FAILURE_POLICY_ID = "CamelAuthenticationFailurePolicyId";
    @Deprecated(since="2.20.0")
    public static final String ACCEPT_CONTENT_TYPE = "CamelAcceptContentType";
    @Metadata(label="aggregate", description="Number of exchanges that was grouped together.", javaType="int")
    public static final String AGGREGATED_SIZE = "CamelAggregatedSize";
    @Metadata(label="aggregate", description="The time in millis this group will timeout", javaType="long")
    public static final String AGGREGATED_TIMEOUT = "CamelAggregatedTimeout";
    @Metadata(label="aggregate", description="Enum that tell how this group was completed", enums="consumer,force,interval,predicate,size,strategy,timeout", javaType="String")
    public static final String AGGREGATED_COMPLETED_BY = "CamelAggregatedCompletedBy";
    @Metadata(label="aggregate", description="The correlation key for this aggregation group", javaType="String")
    public static final String AGGREGATED_CORRELATION_KEY = "CamelAggregatedCorrelationKey";
    public static final String AGGREGATED_COLLECTION_GUARD = "CamelAggregatedCollectionGuard";
    public static final String AGGREGATION_STRATEGY = "CamelAggregationStrategy";
    @Metadata(label="consumer,aggregate", description="Input property. Set to true to force completing the current group. This allows to overrule any existing completion predicates, sizes, timeouts etc, and complete the group.", javaType="boolean")
    public static final String AGGREGATION_COMPLETE_CURRENT_GROUP = "CamelAggregationCompleteCurrentGroup";
    @Metadata(label="consumer,aggregate", description="Input property. Set to true to force completing all the groups (excluding this message). This allows to overrule any existing completion predicates, sizes, timeouts etc, and complete the group. This message is considered a signal message only, the message headers/contents will not be processed otherwise. Instead use CamelAggregationCompleteAllGroupsInclusive if this message should be included in the aggregator.", javaType="boolean")
    public static final String AGGREGATION_COMPLETE_ALL_GROUPS = "CamelAggregationCompleteAllGroups";
    @Metadata(label="consumer,aggregate", description="Input property. Set to true to force completing all the groups (including this message). This allows to overrule any existing completion predicates, sizes, timeouts etc, and complete the group.", javaType="boolean")
    public static final String AGGREGATION_COMPLETE_ALL_GROUPS_INCLUSIVE = "CamelAggregationCompleteAllGroupsInclusive";
    public static final String ASYNC_WAIT = "CamelAsyncWait";
    @Metadata(description="The number of Multipart files uploaded with a single request")
    public static final String ATTACHMENTS_SIZE = "CamelAttachmentsSize";
    public static final String BATCH_INDEX = "CamelBatchIndex";
    public static final String BATCH_SIZE = "CamelBatchSize";
    public static final String BATCH_COMPLETE = "CamelBatchComplete";
    public static final String BINDING = "CamelBinding";
    public static final String BREADCRUMB_ID = "breadcrumbId";
    public static final String CHARSET_NAME = "CamelCharsetName";
    @Deprecated(since="4.5.0")
    public static final String CIRCUIT_BREAKER_STATE = "CamelCircuitBreakerState";
    @Deprecated(since="3.1.0")
    public static final String CREATED_TIMESTAMP = "CamelCreatedTimestamp";
    public static final String CLAIM_CHECK_REPOSITORY = "CamelClaimCheckRepository";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String COOKIE_HANDLER = "CamelCookieHandler";
    public static final String CORRELATION_ID = "CamelCorrelationId";
    public static final String CONTENT_SCHEMA = "CamelContentSchema";
    public static final String CONTENT_SCHEMA_TYPE = "CamelContentSchemaType";
    public static final String DATASET_INDEX = "CamelDataSetIndex";
    public static final String DEFAULT_CHARSET_PROPERTY = "org.apache.camel.default.charset";
    public static final String DESTINATION_OVERRIDE_URL = "CamelDestinationOverrideUrl";
    public static final String DISABLE_HTTP_STREAM_CACHE = "CamelDisableHttpStreamCache";
    @Metadata(label="idempotentConsumer", description="Whether this exchange is a duplicate detected by the Idempotent Consumer EIP", javaType="boolean")
    public static final String DUPLICATE_MESSAGE = "CamelDuplicateMessage";
    public static final String DOCUMENT_BUILDER_FACTORY = "CamelDocumentBuilderFactory";
    @Metadata(label="doCatch,doFinally,errorHandler,onException", description="Stores the caught exception due to a processing error of the current Exchange", javaType="java.lang.Exception")
    public static final String EXCEPTION_CAUGHT = "CamelExceptionCaught";
    public static final String EXCEPTION_HANDLED = "CamelExceptionHandled";
    public static final String EVALUATE_EXPRESSION_RESULT = "CamelEvaluateExpressionResult";
    public static final String ERRORHANDLER_BRIDGE = "CamelErrorHandlerBridge";
    public static final String ERRORHANDLER_CIRCUIT_DETECTED = "CamelErrorHandlerCircuitDetected";
    @Deprecated(since="3.1.0")
    public static final String ERRORHANDLER_HANDLED = "CamelErrorHandlerHandled";
    @Deprecated(since="3.1.0")
    public static final String EXTERNAL_REDELIVERED = "CamelExternalRedelivered";
    @Deprecated(since="4.0.0")
    public static final String FAILURE_HANDLED = "CamelFailureHandled";
    @Metadata(label="doCatch,doFinally,errorHandler,onException", description="Endpoint URI where the Exchange failed during processing", javaType="String")
    public static final String FAILURE_ENDPOINT = "CamelFailureEndpoint";
    @Metadata(label="doCatch,doFinally,errorHandler,onException", description="Route ID where the Exchange failed during processing", javaType="String")
    public static final String FAILURE_ROUTE_ID = "CamelFailureRouteId";
    public static final String FATAL_FALLBACK_ERROR_HANDLER = "CamelFatalFallbackErrorHandler";
    public static final String FILE_CONTENT_TYPE = "CamelFileContentType";
    public static final String FILE_LOCAL_WORK_PATH = "CamelFileLocalWorkPath";
    public static final String FILE_NAME = "CamelFileName";
    public static final String FILE_NAME_ONLY = "CamelFileNameOnly";
    public static final String FILE_NAME_PRODUCED = "CamelFileNameProduced";
    public static final String FILE_NAME_CONSUMED = "CamelFileNameConsumed";
    public static final String FILE_PATH = "CamelFilePath";
    public static final String FILE_PARENT = "CamelFileParent";
    public static final String FILE_LAST_MODIFIED = "CamelFileLastModified";
    public static final String FILE_LENGTH = "CamelFileLength";
    public static final String FILE_LOCK_FILE_ACQUIRED = "CamelFileLockFileAcquired";
    public static final String FILE_LOCK_FILE_NAME = "CamelFileLockFileName";
    public static final String FILE_LOCK_EXCLUSIVE_LOCK = "CamelFileLockExclusiveLock";
    public static final String FILE_LOCK_RANDOM_ACCESS_FILE = "CamelFileLockRandomAccessFile";
    public static final String FILE_LOCK_CHANNEL_FILE = "CamelFileLockChannelFile";
    public static final String FILE_EXCHANGE_FILE = "CamelFileExchangeFile";
    @Deprecated(since="3.9.0")
    public static final String FILTER_MATCHED = "CamelFilterMatched";
    public static final String FILTER_NON_XML_CHARS = "CamelFilterNonXmlChars";
    public static final String GROUPED_EXCHANGE = "CamelGroupedExchange";
    public static final String HTTP_SCHEME = "CamelHttpScheme";
    public static final String HTTP_HOST = "CamelHttpHost";
    public static final String HTTP_PORT = "CamelHttpPort";
    public static final String HTTP_BASE_URI = "CamelHttpBaseUri";
    public static final String HTTP_CHARACTER_ENCODING = "CamelHttpCharacterEncoding";
    public static final String HTTP_METHOD = "CamelHttpMethod";
    public static final String HTTP_PATH = "CamelHttpPath";
    public static final String HTTP_PROTOCOL_VERSION = "CamelHttpProtocolVersion";
    public static final String HTTP_QUERY = "CamelHttpQuery";
    public static final String HTTP_RAW_QUERY = "CamelHttpRawQuery";
    public static final String HTTP_RESPONSE_CODE = "CamelHttpResponseCode";
    public static final String HTTP_RESPONSE_TEXT = "CamelHttpResponseText";
    public static final String HTTP_URI = "CamelHttpUri";
    public static final String HTTP_URL = "CamelHttpUrl";
    public static final String HTTP_CHUNKED = "CamelHttpChunked";
    @Deprecated(since="4.7.0")
    public static final String HTTP_SERVLET_REQUEST = "CamelHttpServletRequest";
    @Deprecated(since="4.7.0")
    public static final String HTTP_SERVLET_RESPONSE = "CamelHttpServletResponse";
    @Metadata(label="interceptFrom,interceptSendToEndpoint", description="The endpoint URI that was intercepted", javaType="String")
    public static final String INTERCEPTED_ENDPOINT = "CamelInterceptedEndpoint";
    @Metadata(label="intercept,interceptFrom,interceptSendToEndpoint", description="The intercepted route's node ID", javaType="String")
    public static final String INTERCEPTED_NODE_ID = "CamelInterceptedNodeId";
    @Metadata(label="intercept,interceptFrom,interceptSendToEndpoint", description="The route's endpoint URI that was intercepted", javaType="String")
    public static final String INTERCEPTED_ROUTE_ENDPOINT_URI = "CamelInterceptedParentEndpointUri";
    @Metadata(label="intercept,interceptFrom,interceptSendToEndpoint", description="The intercepted route's ID", javaType="String")
    public static final String INTERCEPTED_ROUTE_ID = "CamelInterceptedRouteId";
    public static final String INTERCEPT_SEND_TO_ENDPOINT_WHEN_MATCHED = "CamelInterceptSendToEndpointWhenMatched";
    @Deprecated(since="3.1.0")
    public static final String INTERRUPTED = "CamelInterrupted";
    public static final String LANGUAGE_SCRIPT = "CamelLanguageScript";
    public static final String LOG_DEBUG_BODY_MAX_CHARS = "CamelLogDebugBodyMaxChars";
    public static final String LOG_DEBUG_BODY_STREAMS = "CamelLogDebugStreams";
    public static final String LOG_EIP_NAME = "CamelLogEipName";
    public static final String LOG_EIP_LANGUAGE = "CamelLogEipLanguage";
    @Metadata(label="loop", description="Index of the current iteration (0 based).", javaType="int")
    public static final String LOOP_INDEX = "CamelLoopIndex";
    @Metadata(label="loop", description="Total number of loops. This is not available if running the loop in while loop mode.", javaType="int")
    public static final String LOOP_SIZE = "CamelLoopSize";
    public static final String MAXIMUM_CACHE_POOL_SIZE = "CamelMaximumCachePoolSize";
    public static final String MAXIMUM_ENDPOINT_CACHE_SIZE = "CamelMaximumEndpointCacheSize";
    public static final String MAXIMUM_SIMPLE_CACHE_SIZE = "CamelMaximumSimpleCacheSize";
    public static final String MAXIMUM_TRANSFORMER_CACHE_SIZE = "CamelMaximumTransformerCacheSize";
    public static final String MAXIMUM_VALIDATOR_CACHE_SIZE = "CamelMaximumValidatorCacheSize";
    public static final String MESSAGE_HISTORY = "CamelMessageHistory";
    public static final String MESSAGE_HISTORY_HEADER_FORMAT = "CamelMessageHistoryHeaderFormat";
    public static final String MESSAGE_HISTORY_OUTPUT_FORMAT = "CamelMessageHistoryOutputFormat";
    public static final String MESSAGE_TIMESTAMP = "CamelMessageTimestamp";
    @Metadata(label="multicast", description="An index counter that increases for each Exchange being multicasted. The counter starts from 0.", javaType="int")
    public static final String MULTICAST_INDEX = "CamelMulticastIndex";
    @Metadata(label="multicast", description="Whether this Exchange is the last.", javaType="boolean")
    public static final String MULTICAST_COMPLETE = "CamelMulticastComplete";
    @Deprecated(since="3.1.0")
    public static final String NOTIFY_EVENT = "CamelNotifyEvent";
    @Metadata(label="onCompletion", description="Flag to mark that this exchange is currently being executed as onCompletion", javaType="boolean")
    public static final String ON_COMPLETION = "CamelOnCompletion";
    public static final String ON_COMPLETION_ROUTE_IDS = "CamelOnCompletionRouteIds";
    public static final String OFFSET = "CamelOffset";
    public static final String OVERRULE_FILE_NAME = "CamelOverruleFileName";
    public static final String PARENT_UNIT_OF_WORK = "CamelParentUnitOfWork";
    public static final String STREAM_CACHE_UNIT_OF_WORK = "CamelStreamCacheUnitOfWork";
    @Metadata(label="recipientList", description="The endpoint uri of this recipient list", javaType="String")
    public static final String RECIPIENT_LIST_ENDPOINT = "CamelRecipientListEndpoint";
    public static final String RECEIVED_TIMESTAMP = "CamelReceivedTimestamp";
    public static final String REDELIVERED = "CamelRedelivered";
    public static final String REDELIVERY_COUNTER = "CamelRedeliveryCounter";
    public static final String REDELIVERY_MAX_COUNTER = "CamelRedeliveryMaxCounter";
    @Deprecated(since="3.1.0")
    public static final String REDELIVERY_EXHAUSTED = "CamelRedeliveryExhausted";
    public static final String REDELIVERY_DELAY = "CamelRedeliveryDelay";
    public static final String REST_HTTP_URI = "CamelRestHttpUri";
    public static final String REST_HTTP_QUERY = "CamelRestHttpQuery";
    public static final String REST_OPENAPI = "CamelRestOpenAPI";
    @Deprecated(since="3.1.0")
    public static final String ROLLBACK_ONLY = "CamelRollbackOnly";
    @Deprecated(since="3.1.0")
    public static final String ROLLBACK_ONLY_LAST = "CamelRollbackOnlyLast";
    @Deprecated(since="3.1.0")
    public static final String ROUTE_STOP = "CamelRouteStop";
    public static final String SAGA_LONG_RUNNING_ACTION = "Long-Running-Action";
    @Deprecated(since="3.15.0")
    public static final String SAXPARSER_FACTORY = "CamelSAXParserFactory";
    public static final String SCHEDULER_POLLED_MESSAGES = "CamelSchedulerPolledMessages";
    @Deprecated(since="3.15.0")
    public static final String SOAP_ACTION = "CamelSoapAction";
    public static final String SKIP_GZIP_ENCODING = "CamelSkipGzipEncoding";
    public static final String SKIP_WWW_FORM_URLENCODED = "CamelSkipWwwFormUrlEncoding";
    @Metadata(label="routingSlip", description="The endpoint uri of this routing slip", javaType="String")
    public static final String SLIP_ENDPOINT = "CamelSlipEndpoint";
    public static final String SLIP_PRODUCER = "CamelSlipProducer";
    @Metadata(label="split", description="A split counter that increases for each Exchange being split. The counter starts from 0.", javaType="int")
    public static final String SPLIT_INDEX = "CamelSplitIndex";
    @Metadata(label="split", description="Whether this Exchange is the last.", javaType="boolean")
    public static final String SPLIT_COMPLETE = "CamelSplitComplete";
    @Metadata(label="split", description="The total number of Exchanges that was split. This property is not applied for stream based splitting, except for the very last message because then Camel knows the total size.", javaType="int")
    public static final String SPLIT_SIZE = "CamelSplitSize";
    @Metadata(label="step", description="The id of the Step EIP", javaType="String")
    public static final String STEP_ID = "CamelStepId";
    public static final String TIMER_COUNTER = "CamelTimerCounter";
    public static final String TIMER_FIRED_TIME = "CamelTimerFiredTime";
    public static final String TIMER_NAME = "CamelTimerName";
    public static final String TIMER_PERIOD = "CamelTimerPeriod";
    public static final String TIMER_TIME = "CamelTimerTime";
    @Metadata(label="enrich,multicast,pollEnrich,recipientList,routingSlip,toD,to,wireTap", description="Endpoint URI where this Exchange is being sent to", javaType="String")
    public static final String TO_ENDPOINT = "CamelToEndpoint";
    @Deprecated(since="4.0.0")
    public static final String TRACE_EVENT = "CamelTraceEvent";
    @Deprecated(since="4.0.0")
    public static final String TRACE_EVENT_NODE_ID = "CamelTraceEventNodeId";
    @Deprecated(since="4.0.0")
    public static final String TRACE_EVENT_TIMESTAMP = "CamelTraceEventTimestamp";
    @Deprecated(since="4.0.0")
    public static final String TRACE_EVENT_EXCHANGE = "CamelTraceEventExchange";
    @Deprecated(since="3.15.0")
    public static final String TRACING_HEADER_FORMAT = "CamelTracingHeaderFormat";
    @Deprecated(since="3.15.0")
    public static final String TRACING_OUTPUT_FORMAT = "CamelTracingOutputFormat";
    public static final String TRANSACTION_CONTEXT_DATA = "CamelTransactionContextData";
    public static final String TRY_ROUTE_BLOCK = "TryRouteBlock";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UNIT_OF_WORK_EXHAUSTED = "CamelUnitOfWorkExhausted";
    public static final String XSLT_FILE_NAME = "CamelXsltFileName";
    public static final String XSLT_ERROR = "CamelXsltError";
    public static final String XSLT_FATAL_ERROR = "CamelXsltFatalError";
    public static final String XSLT_WARNING = "CamelXsltWarning";
    public static final String OTEL_ACTIVE_SPAN = "OpenTracing.activeSpan";
    public static final String OTEL_CLOSE_CLIENT_SCOPE = "OpenTracing.closeClientScope";

    public ExchangePattern getPattern();

    public void setPattern(ExchangePattern var1);

    public Object getProperty(ExchangePropertyKey var1);

    public <T> T getProperty(ExchangePropertyKey var1, Class<T> var2);

    public <T> T getProperty(ExchangePropertyKey var1, Object var2, Class<T> var3);

    public void setProperty(ExchangePropertyKey var1, Object var2);

    public Object removeProperty(ExchangePropertyKey var1);

    public Object getProperty(String var1);

    public <T> T getProperty(String var1, Class<T> var2);

    public <T> T getProperty(String var1, Object var2, Class<T> var3);

    public void setProperty(String var1, Object var2);

    public Object removeProperty(String var1);

    public boolean removeProperties(String var1);

    public boolean removeProperties(String var1, String ... var2);

    public Map<String, Object> getProperties();

    public Map<String, Object> getAllProperties();

    public boolean hasProperties();

    @Override
    public Object getVariable(String var1);

    public <T> T getVariable(String var1, Class<T> var2);

    public <T> T getVariable(String var1, Object var2, Class<T> var3);

    @Override
    public void setVariable(String var1, Object var2);

    public Object removeVariable(String var1);

    public Map<String, Object> getVariables();

    public boolean hasVariables();

    public Message getIn();

    public Message getMessage();

    public <T> T getMessage(Class<T> var1);

    public void setMessage(Message var1);

    public <T> T getIn(Class<T> var1);

    public void setIn(Message var1);

    @Deprecated(since="3.0.0")
    public Message getOut();

    @Deprecated(since="3.0.0")
    public <T> T getOut(Class<T> var1);

    @Deprecated(since="3.0.0")
    public boolean hasOut();

    @Deprecated(since="3.0.0")
    public void setOut(Message var1);

    public Exception getException();

    public <T> T getException(Class<T> var1);

    public void setException(Throwable var1);

    public boolean isFailed();

    public boolean isTransacted();

    public boolean isRouteStop();

    public void setRouteStop(boolean var1);

    public boolean isExternalRedelivered();

    public boolean isRollbackOnly();

    public void setRollbackOnly(boolean var1);

    public boolean isRollbackOnlyLast();

    public void setRollbackOnlyLast(boolean var1);

    public CamelContext getContext();

    public Exchange copy();

    public Endpoint getFromEndpoint();

    public String getFromRouteId();

    public UnitOfWork getUnitOfWork();

    public String getExchangeId();

    public void setExchangeId(String var1);

    @Deprecated(since="4.4.0")
    public long getCreated();

    public ExchangeExtension getExchangeExtension();

    public Clock getClock();
}

