/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.resume;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Predicate;

public interface ResumableSet<T> {
    default public T[] resumeEach(T[] input, Predicate<T> resumableCheck) {
        Object[] tmp = (Object[])Array.newInstance(input.getClass().getComponentType(), input.length);
        int count = 0;
        for (T entry : input) {
            if (!resumableCheck.test(entry)) continue;
            tmp[count] = entry;
            ++count;
        }
        if (count != input.length) {
            return Arrays.copyOf(tmp, count);
        }
        return input;
    }

    public void resumeEach(Predicate<T> var1);

    public T[] resumed();

    public boolean hasResumables();
}

