/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.maven.AbstractApiMethodBaseMojo;
import org.apache.camel.maven.ApiMethodAlias;
import org.apache.camel.maven.ExtraOption;
import org.apache.camel.maven.SignatureModel;
import org.apache.camel.maven.Substitution;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodParser;
import org.apache.camel.support.component.ArgumentSubstitutionParser;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.commons.lang3.ClassUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.velocity.VelocityContext;

public abstract class AbstractApiMethodGeneratorMojo
extends AbstractApiMethodBaseMojo {
    private static final Map<Class<?>, String> PRIMITIVE_VALUES = new HashMap();
    @Parameter(required=true, property="org.apache.camel.proxyClass")
    protected String proxyClass;
    @Parameter
    protected String classPrefix;
    @Parameter
    protected String apiName;
    @Parameter
    protected String apiDescription;
    @Parameter
    protected boolean consumerOnly;
    @Parameter
    protected boolean producerOnly;
    @Parameter
    protected List<ApiMethodAlias> aliases = Collections.emptyList();
    @Parameter
    protected String[] nullableOptions;
    private Class<?> proxyType;
    private Pattern propertyNamePattern;
    private Pattern propertyTypePattern;

    @Override
    public void executeInternal() throws MojoExecutionException {
        this.setCompileSourceRoots();
        Class<?> proxyType = this.getProxyType();
        if (this.excludeConfigNames != null) {
            this.propertyNamePattern = Pattern.compile(this.excludeConfigNames);
        }
        if (this.excludeConfigTypes != null) {
            this.propertyTypePattern = Pattern.compile(this.excludeConfigTypes);
        }
        ApiMethodParser<?> parser = this.createAdapterParser(proxyType);
        ArrayList<String> signatures = new ArrayList<String>();
        HashMap parameters = new HashMap();
        List<SignatureModel> data = this.getSignatureList();
        for (SignatureModel model : data) {
            if (model.getApiDescription() != null) {
                this.apiDescription = model.getApiDescription();
            }
            signatures.add(model.getSignature());
            String method = StringHelper.before((String)model.getSignature(), (String)"(");
            if (method != null && method.contains(" ")) {
                method = StringHelper.after((String)method, (String)" ");
            }
            if (method != null) {
                HashMap<String, String> docs = new HashMap<String, String>();
                if (model.getParameterDescriptions() != null && !model.getParameterDescriptions().isEmpty()) {
                    docs.putAll(model.getParameterDescriptions());
                }
                if (model.getSetterDescriptions() != null && !model.getSetterDescriptions().isEmpty()) {
                    docs.putAll(model.getSetterDescriptions());
                }
                parameters.put(method, docs);
            }
            parser.getDescriptions().put(method, model.getMethodDescription());
            parser.addSignatureArguments(model.getSignature(), model.getParameterTypes());
            parser.addSignatureProperties(model.getSignature(), model.getSetterTypes());
        }
        parser.setSignatures(signatures);
        parser.setParameters(parameters);
        parser.setClassLoader(this.getProjectClassLoader());
        List models = parser.parse();
        this.mergeTemplate(this.getApiMethodContext(models), this.getApiMethodFile(), "/api-method-enum.vm");
        this.mergeTemplate(this.getEndpointContext(models), this.getConfigurationFile(), "/api-endpoint-config.vm");
        String testFilePath = this.getTestFilePath();
        if (!new File(this.project.getBuild().getTestSourceDirectory(), testFilePath).exists()) {
            this.mergeTemplate(this.getApiTestContext(models), new File(this.generatedTestDir, testFilePath), "/api-route-test.vm");
        }
    }

    protected ApiMethodParser<?> createAdapterParser(Class<?> proxyType) {
        return new ArgumentSubstitutionParser(proxyType, this.getArgumentSubstitutions());
    }

    public abstract List<SignatureModel> getSignatureList() throws MojoExecutionException;

    public Class<?> getProxyType() throws MojoExecutionException {
        if (this.proxyType == null) {
            try {
                this.proxyType = this.getProjectClassLoader().loadClass(this.proxyClass);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        return this.proxyType;
    }

    private VelocityContext getApiMethodContext(List<ApiMethodParser.ApiMethodModel> models) throws MojoExecutionException {
        VelocityContext context = this.getCommonContext(models);
        context.put("enumName", (Object)this.getEnumName());
        return context;
    }

    public File getApiMethodFile() {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.outPackage.replace(".", Matcher.quoteReplacement(File.separator))).append(File.separator);
        fileName.append(this.getEnumName()).append(".java");
        return new File(this.generatedSrcDir, fileName.toString());
    }

    private String getEnumName() {
        String proxyClassWithCanonicalName = this.getProxyClassWithCanonicalName(this.proxyClass);
        String prefix = this.classPrefix != null ? this.classPrefix : "";
        return prefix + proxyClassWithCanonicalName.substring(proxyClassWithCanonicalName.lastIndexOf(46) + 1) + "ApiMethod";
    }

    private VelocityContext getApiTestContext(List<ApiMethodParser.ApiMethodModel> models) throws MojoExecutionException {
        VelocityContext context = this.getCommonContext(models);
        context.put("testName", (Object)this.getUnitTestName());
        context.put("scheme", (Object)this.scheme);
        context.put("componentPackage", (Object)this.componentPackage);
        context.put("componentName", (Object)this.componentName);
        context.put("enumName", (Object)this.getEnumName());
        return context;
    }

    private String getTestFilePath() {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.componentPackage.replace(".", Matcher.quoteReplacement(File.separator))).append(File.separator);
        fileName.append(this.getUnitTestName()).append(".java");
        return fileName.toString();
    }

    private String getUnitTestName() {
        String proxyClassWithCanonicalName = this.getProxyClassWithCanonicalName(this.proxyClass);
        String prefix = this.classPrefix != null ? this.classPrefix : "";
        return prefix + proxyClassWithCanonicalName.substring(proxyClassWithCanonicalName.lastIndexOf(46) + 1) + "IT";
    }

    private VelocityContext getEndpointContext(List<ApiMethodParser.ApiMethodModel> models) throws MojoExecutionException {
        String name;
        VelocityContext context = this.getCommonContext(models);
        context.put("apiName", (Object)this.apiName);
        context.put("apiDescription", (Object)this.apiDescription);
        context.put("consumerOnly", (Object)this.consumerOnly);
        context.put("producerOnly", (Object)this.producerOnly);
        context.put("configName", (Object)this.getConfigName());
        context.put("componentName", (Object)this.componentName);
        context.put("componentPackage", (Object)this.componentPackage);
        context.put("nullableOptions", (Object)this.nullableOptions);
        TreeMap<String, ApiMethodArg> parameters = new TreeMap<String, ApiMethodArg>();
        for (ApiMethodParser.ApiMethodModel model : models) {
            for (ApiMethodArg argument : model.getArgumentsAndProperties()) {
                name = argument.getName();
                Class type = argument.getType();
                String typeName = type.getCanonicalName();
                if (parameters.containsKey(name) || this.propertyNamePattern != null && this.propertyNamePattern.matcher(name).matches() || this.propertyTypePattern != null && this.propertyTypePattern.matcher(typeName).matches()) continue;
                parameters.put(name, argument);
            }
        }
        if (this.extraOptions != null && this.extraOptions.length > 0) {
            for (ExtraOption option : this.extraOptions) {
                Class<?> argType;
                name = option.getName();
                String argWithTypes = option.getType().replace(" ", "");
                int rawEnd = argWithTypes.indexOf(60);
                String includeMethods = option.getIncludeMethods();
                String typeArgs = null;
                try {
                    if (rawEnd != -1) {
                        argType = this.getProjectClassLoader().loadClass(argWithTypes.substring(0, rawEnd));
                        typeArgs = argWithTypes.substring(rawEnd + 1, argWithTypes.lastIndexOf(62));
                    } else {
                        argType = this.getProjectClassLoader().loadClass(argWithTypes);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new MojoExecutionException(String.format("Error loading extra option [%s %s] : %s", argWithTypes, name, e.getMessage()), (Exception)e);
                }
                ApiMethodArg arg = new ApiMethodArg(name, argType, typeArgs, argWithTypes, option.getDescription());
                parameters.put(name, arg);
                if (includeMethods == null) continue;
                for (String m : includeMethods.trim().split(",")) {
                    for (ApiMethodParser.ApiMethodModel model : models) {
                        if (!model.getMethod().getName().equals(m)) continue;
                        model.getArguments().add(arg);
                    }
                }
            }
        }
        context.put("parameters", parameters);
        return context;
    }

    private File getConfigurationFile() {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.componentPackage.replace(".", Matcher.quoteReplacement(File.separator))).append(File.separator);
        fileName.append(this.getConfigName()).append(".java");
        return new File(this.generatedSrcDir, fileName.toString());
    }

    private String getConfigName() {
        String proxyClassWithCanonicalName = this.getProxyClassWithCanonicalName(this.proxyClass);
        String prefix = this.classPrefix != null ? this.classPrefix : "";
        return prefix + proxyClassWithCanonicalName.substring(proxyClassWithCanonicalName.lastIndexOf(46) + 1) + "EndpointConfiguration";
    }

    private String getProxyClassWithCanonicalName(String proxyClass) {
        return proxyClass.replace("$", "");
    }

    private VelocityContext getCommonContext(List<ApiMethodParser.ApiMethodModel> models) throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        context.put("models", models);
        context.put("proxyType", this.getProxyType());
        context.put("proxyTypeLink", (Object)this.getProxyType().getName().replace('$', '.'));
        context.put("helper", (Object)this);
        return context;
    }

    public ArgumentSubstitutionParser.Substitution[] getArgumentSubstitutions() {
        ArgumentSubstitutionParser.Substitution[] subs = new ArgumentSubstitutionParser.Substitution[this.substitutions.length];
        for (int i = 0; i < this.substitutions.length; ++i) {
            Substitution substitution = this.substitutions[i];
            subs[i] = new ArgumentSubstitutionParser.Substitution(substitution.getMethod(), substitution.getArgName(), substitution.getArgType(), substitution.getReplacement(), substitution.isReplaceWithType());
        }
        return subs;
    }

    public static String getType(Class<?> clazz) {
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return AbstractApiMethodGeneratorMojo.getCanonicalName(clazz) + ".class";
            }
            return "new " + AbstractApiMethodGeneratorMojo.getCanonicalName(clazz).replaceAll("\\[\\]", "[0]") + ".getClass()";
        }
        return AbstractApiMethodGeneratorMojo.getCanonicalName(clazz) + ".class";
    }

    public String getAliases() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (!this.aliases.isEmpty()) {
            StringJoiner sj = new StringJoiner(", ");
            this.aliases.forEach(a -> sj.add("\"" + a.getMethodPattern() + "=" + a.getMethodAlias() + "\""));
            sb.append(sj);
        }
        sb.append("}");
        return sb.toString();
    }

    public static String getApiMethodsForParam(List<ApiMethodParser.ApiMethodModel> models, ApiMethodArg argument) {
        StringBuilder sb = new StringBuilder();
        HashSet names = new HashSet();
        String key = argument.getName();
        boolean noneMatch = models.stream().noneMatch(m -> m.getArgumentsAndProperties().stream().noneMatch(a -> a.getName().equals(key)));
        models.forEach(p -> {
            ApiMethodArg match = p.getArgumentsAndProperties().stream().filter(a -> a.getName().equals(key)).findFirst().orElse(null);
            if (match != null && names.add(p.getName())) {
                String desc = match.getDescription();
                if (desc == null) {
                    desc = argument.getDescription();
                }
                sb.append("@ApiMethod(methodName = \"").append(p.getName()).append("\"");
                if (ObjectHelper.isNotEmpty((String)desc)) {
                    sb.append(", description=\"").append(desc).append("\"");
                }
                sb.append(")");
                sb.append(", ");
            } else if (noneMatch) {
                String desc = argument.getDescription();
                sb.append("@ApiMethod(methodName = \"").append(p.getName()).append("\"");
                if (ObjectHelper.isNotEmpty((String)desc)) {
                    sb.append(", description=\"").append(desc).append("\"");
                }
                sb.append(")");
                sb.append(", ");
            }
        });
        String answer = sb.toString();
        if (answer.endsWith(", ")) {
            answer = answer.substring(0, answer.length() - 2);
        }
        return "{" + answer + "}";
    }

    public static String getTestName(ApiMethodParser.ApiMethodModel model) {
        StringBuilder builder = new StringBuilder();
        String name = model.getMethod().getName();
        builder.append(Character.toUpperCase(name.charAt(0)));
        builder.append(name, 1, name.length());
        String uniqueName = model.getUniqueName();
        if (uniqueName.length() > name.length()) {
            builder.append(uniqueName, name.length(), uniqueName.length());
        }
        return builder.toString();
    }

    public static boolean isVoidType(Class<?> resultType) {
        return resultType == Void.TYPE;
    }

    public String getExchangePropertyPrefix() {
        return "Camel" + this.componentName + ".";
    }

    public static String getResultDeclaration(Class<?> resultType) {
        if (resultType.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(resultType).getSimpleName();
        }
        return AbstractApiMethodGeneratorMojo.getCanonicalName(resultType);
    }

    public boolean hasDoc(ApiMethodArg argument) {
        return argument.getDescription() != null && !argument.getDescription().isEmpty();
    }

    public String getDoc(ApiMethodArg argument) {
        if (argument.getDescription() == null || argument.getDescription().isEmpty()) {
            return "";
        }
        return argument.getDescription();
    }

    public String getApiName(String apiName) {
        if (apiName == null || apiName.isEmpty()) {
            return "DEFAULT";
        }
        return apiName;
    }

    public String getApiDescription(String apiDescription) {
        if (apiDescription == null) {
            return "";
        }
        return apiDescription;
    }

    public boolean isOptionalParameter(ApiMethodArg argument) {
        String name = argument.getName();
        if (this.nullableOptions != null) {
            for (String nu : this.nullableOptions) {
                if (!name.equalsIgnoreCase(nu)) continue;
                return true;
            }
        }
        return argument.isSetter();
    }

    public String argOrSetter(ApiMethodArg argument) {
        return argument.isSetter() ? "setter" : "arg";
    }

    public boolean isDeprecatedParameter(ApiMethodArg argument) {
        String desc = argument.getDescription();
        return desc != null && desc.trim().startsWith("Deprecated:");
    }

    public String getCanonicalName(ApiMethodArg argument) {
        Class type = argument.getType();
        if (type.isPrimitive()) {
            return AbstractApiMethodGeneratorMojo.getCanonicalName(ClassUtils.primitiveToWrapper((Class)type));
        }
        String fqn = argument.getRawTypeArgs();
        fqn = fqn.replace('$', '.');
        return fqn;
    }

    public String getApiMethods(List<ApiMethodParser.ApiMethodModel> models) {
        models.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        HashSet<String> names = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < models.size(); ++i) {
            List<String> signatures;
            ApiMethodParser.ApiMethodModel model = models.get(i);
            String name = model.getName();
            if (!names.add(name)) continue;
            sb.append("@ApiMethod(methodName = \"").append(model.getName()).append("\"");
            String desc = model.getDescription();
            if (ObjectHelper.isNotEmpty((String)desc)) {
                sb.append(", description=\"").append(desc).append("\"");
            }
            if (!(signatures = this.getSignatures(models, name)).isEmpty()) {
                sb.append(", signatures={");
                StringJoiner sj = new StringJoiner(", ");
                signatures.forEach(s -> sj.add("\"" + s + "\""));
                sb.append(sj);
                sb.append("}");
            }
            sb.append(")");
            if (i >= models.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private List<String> getSignatures(List<ApiMethodParser.ApiMethodModel> models, String methodName) {
        ArrayList<String> list = new ArrayList<String>();
        for (ApiMethodParser.ApiMethodModel model : models) {
            if (!model.getName().equals(methodName) || model.getSignature() == null) continue;
            list.add(model.getSignature());
        }
        return list;
    }

    public static String getDefaultArgValue(Class<?> aClass) {
        if (aClass.isPrimitive()) {
            return PRIMITIVE_VALUES.get(aClass);
        }
        return "null";
    }

    public static String getBeanPropertySuffix(String parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toUpperCase(parameter.charAt(0)));
        builder.append(parameter, 1, parameter.length());
        return builder.toString();
    }

    static {
        PRIMITIVE_VALUES.put(Boolean.TYPE, "Boolean.FALSE");
        PRIMITIVE_VALUES.put(Byte.TYPE, "(byte) 0");
        PRIMITIVE_VALUES.put(Character.TYPE, "(char) 0");
        PRIMITIVE_VALUES.put(Short.TYPE, "(short) 0");
        PRIMITIVE_VALUES.put(Integer.TYPE, "0");
        PRIMITIVE_VALUES.put(Long.TYPE, "0L");
        PRIMITIVE_VALUES.put(Float.TYPE, "0.0f");
        PRIMITIVE_VALUES.put(Double.TYPE, "0.0d");
    }
}

