/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.amqp;

import jakarta.jms.ConnectionFactory;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class AMQPConfiguration
extends JmsConfiguration {
    @UriParam(label="consumer,advanced", description="Whether to include AMQP annotations when mapping from AMQP to Camel Message. Setting this to true maps AMQP message annotations that contain a JMS_AMQP_MA_ prefix to message headers. Due to limitations in Apache Qpid JMS API, currently delivery annotations are ignored.")
    private boolean includeAmqpAnnotations;

    public AMQPConfiguration() {
    }

    public AMQPConfiguration(ConnectionFactory connectionFactory) {
        super(connectionFactory);
    }

    public boolean isIncludeAmqpAnnotations() {
        return this.includeAmqpAnnotations;
    }

    public void setIncludeAmqpAnnotations(boolean includeAmqpAnnotations) {
        this.includeAmqpAnnotations = includeAmqpAnnotations;
    }
}

