/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.amqp;

import jakarta.jms.ConnectionFactory;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.amqp.AMQPConfiguration;
import org.apache.camel.component.amqp.AMQPConnectionDetails;
import org.apache.camel.component.amqp.AMQPJmsBinding;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="amqp")
public class AMQPComponent
extends JmsComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AMQPComponent.class);
    public static final String AMQP_DEFAULT_HOST = "localhost";
    public static final int AMQP_DEFAULT_PORT = 5672;
    @Metadata(description="Remote URL to broker. The URL is used to setup connection factory and is broker specific (such as ActiveMQ).")
    private String brokerUrl;
    @Metadata(description="The host name or IP address of the computer that hosts the AMQP Broker.")
    private String host;
    @Metadata(description="The port number on which the AMPQ Broker listens.")
    private Integer port;
    @Metadata(description="Whether to configure topics with a `topic://` prefix.")
    private Boolean useTopicPrefix;
    @Metadata(description="Whether to enable SSL when connecting to the AMQP Broker.")
    private Boolean useSsl;
    @Metadata(description="The SSL keystore location.")
    private String keyStoreLocation;
    @Metadata(defaultValue="JKS", description="The SSL keystore type.")
    private String keyStoreType = "JKS";
    @Metadata(label="security", secret=true, description="The SSL keystore password.")
    private String keyStorePassword;
    @Metadata(description="The SSL truststore location.")
    private String trustStoreLocation;
    @Metadata(defaultValue="JKS", description="The SSL truststore type.")
    private String trustStoreType = "JKS";
    @Metadata(label="security", secret=true, description="The SSL truststore password.")
    private String trustStorePassword;

    public AMQPComponent() {
    }

    public AMQPComponent(JmsConfiguration configuration) {
        super(configuration);
    }

    public AMQPComponent(CamelContext context) {
        super(context);
    }

    public AMQPComponent(ConnectionFactory connectionFactory) {
        this();
        this.getConfiguration().setConnectionFactory(connectionFactory);
    }

    public static AMQPComponent amqpComponent(String uri) {
        JmsConnectionFactory connectionFactory = new JmsConnectionFactory(uri);
        connectionFactory.setTopicPrefix("topic://");
        return new AMQPComponent((ConnectionFactory)connectionFactory);
    }

    public static AMQPComponent amqpComponent(String uri, String username, String password) {
        JmsConnectionFactory connectionFactory = new JmsConnectionFactory(username, password, uri);
        connectionFactory.setTopicPrefix("topic://");
        return new AMQPComponent((ConnectionFactory)connectionFactory);
    }

    protected void doInit() throws Exception {
        if (this.brokerUrl != null) {
            JmsConnectionFactory connectionFactory = new JmsConnectionFactory(this.brokerUrl);
            if (this.useTopicPrefix != Boolean.FALSE) {
                connectionFactory.setTopicPrefix("topic://");
            }
            this.getConfiguration().setConnectionFactory((ConnectionFactory)connectionFactory);
        } else if (this.host != null || this.port != null || this.getUsername() != null || this.getPassword() != null || this.useTopicPrefix != null || this.useSsl != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.useSsl == Boolean.TRUE ? "amqps://" : "amqp://");
            sb.append(this.host == null ? AMQP_DEFAULT_HOST : this.host).append(":").append(this.port == null ? 5672 : this.port);
            if (this.useSsl == Boolean.TRUE) {
                sb.append("?transport.trustStoreLocation=").append(this.trustStoreLocation == null ? "" : this.trustStoreLocation);
                sb.append("&transport.trustStoreType=").append(this.trustStoreType);
                sb.append("&transport.trustStorePassword=").append(this.trustStorePassword == null ? "" : this.trustStorePassword);
                sb.append("&transport.keyStoreLocation=").append(this.keyStoreLocation == null ? "" : this.keyStoreLocation);
                sb.append("&transport.keyStoreType=").append(this.keyStoreType);
                sb.append("&transport.keyStorePassword=").append(this.keyStorePassword == null ? "" : this.keyStorePassword);
            }
            JmsConnectionFactory connectionFactory = new JmsConnectionFactory(this.getUsername(), this.getPassword(), sb.toString());
            if (this.useTopicPrefix != Boolean.FALSE) {
                connectionFactory.setTopicPrefix("topic://");
            }
            this.getConfiguration().setConnectionFactory((ConnectionFactory)connectionFactory);
        } else {
            Set connectionDetails = this.getCamelContext().getRegistry().findByType(AMQPConnectionDetails.class);
            if (connectionDetails.size() == 1) {
                LOG.warn("Using AMQPConnectionDetails is deprecated");
                AMQPConnectionDetails details = (AMQPConnectionDetails)connectionDetails.iterator().next();
                JmsConnectionFactory connectionFactory = new JmsConnectionFactory(details.username(), details.password(), details.uri());
                if (details.setTopicPrefix()) {
                    connectionFactory.setTopicPrefix("topic://");
                }
                this.getConfiguration().setConnectionFactory((ConnectionFactory)connectionFactory);
            }
        }
        super.doInit();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JmsEndpoint endpoint = (JmsEndpoint)super.createEndpoint(uri, remaining, parameters);
        endpoint.setBinding((JmsBinding)new AMQPJmsBinding(endpoint));
        return endpoint;
    }

    protected JmsConfiguration createConfiguration() {
        return new AMQPConfiguration();
    }

    @Metadata(displayName="Include AMQP Annotations")
    public void setIncludeAmqpAnnotations(boolean includeAmqpAnnotations) {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof AMQPConfiguration) {
            AMQPConfiguration amqpConfiguration = (AMQPConfiguration)jmsConfiguration;
            amqpConfiguration.setIncludeAmqpAnnotations(includeAmqpAnnotations);
        }
    }

    public boolean isIncludeAmqpAnnotations() {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof AMQPConfiguration) {
            AMQPConfiguration amqpConfiguration = (AMQPConfiguration)jmsConfiguration;
            return amqpConfiguration.isIncludeAmqpAnnotations();
        }
        return false;
    }

    protected void setProperties(Endpoint bean, Map<String, Object> parameters) throws Exception {
        Object includeAmqpAnnotations = parameters.remove("includeAmqpAnnotations");
        if (includeAmqpAnnotations != null) {
            ((AMQPConfiguration)((JmsEndpoint)bean).getConfiguration()).setIncludeAmqpAnnotations((Boolean)PropertyConfigurerSupport.property((CamelContext)this.getCamelContext(), Boolean.TYPE, (Object)includeAmqpAnnotations));
        }
        super.setProperties(bean, parameters);
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean getUseTopicPrefix() {
        return this.useTopicPrefix;
    }

    public void setUseTopicPrefix(Boolean useTopicPrefix) {
        this.useTopicPrefix = useTopicPrefix;
    }

    public Boolean getUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }
}

