/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt.model;

import java.util.Set;
import org.apache.camel.tools.apt.helper.Strings;

public final class EndpointOption {
    private String name;
    private String displayName;
    private String type;
    private boolean required;
    private String defaultValue;
    private String defaultValueNote;
    private String documentation;
    private String optionalPrefix;
    private String prefix;
    private boolean multiValue;
    private boolean deprecated;
    private String deprecationNote;
    private boolean secret;
    private String group;
    private String label;
    private boolean enumType;
    private Set<String> enums;
    private String configurationClass;
    private String configurationField;

    public EndpointOption(String name, String displayName, String type, boolean required, String defaultValue, String defaultValueNote, String documentation, String optionalPrefix, String prefix, boolean multiValue, boolean deprecated, String deprecationNote, boolean secret, String group, String label, boolean enumType, Set<String> enums, String configurationClass, String nestedFieldName) {
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.required = required;
        this.defaultValue = defaultValue;
        this.defaultValueNote = defaultValueNote;
        this.documentation = documentation;
        this.optionalPrefix = optionalPrefix;
        this.prefix = prefix;
        this.multiValue = multiValue;
        this.deprecated = deprecated;
        this.deprecationNote = deprecationNote;
        this.secret = secret;
        this.group = group;
        this.label = label;
        this.enumType = enumType;
        this.enums = enums;
        this.configurationClass = configurationClass;
        this.configurationField = nestedFieldName;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getOptionalPrefix() {
        return this.optionalPrefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getDeprecationNote() {
        return this.deprecationNote;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public String getDocumentationWithNotes() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.documentation);
        if (!Strings.isNullOrEmpty(this.defaultValueNote)) {
            sb.append(". Default value notice: ").append(this.defaultValueNote);
        }
        if (!Strings.isNullOrEmpty(this.deprecationNote)) {
            sb.append(". Deprecation note: ").append(this.deprecationNote);
        }
        return sb.toString();
    }

    public boolean isEnumType() {
        return this.enumType;
    }

    public Set<String> getEnums() {
        return this.enums;
    }

    public String getConfigurationClass() {
        return this.configurationClass;
    }

    public String getConfigurationField() {
        return this.configurationField;
    }

    public String getGroup() {
        return this.group;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointOption that = (EndpointOption)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

