/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.camel.spi.annotations.ServiceFactory;
import org.apache.camel.spi.annotations.SubServiceFactory;
import org.apache.camel.tools.apt.AbstractCamelAnnotationProcessor;
import org.apache.camel.tools.apt.helper.Strings;

@SupportedAnnotationTypes(value={"org.apache.camel.spi.annotations.*"})
public class SpiProcessor
extends AbstractCamelAnnotationProcessor {
    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        roundEnv.getRootElements().stream().filter(e -> e instanceof TypeElement).map(TypeElement.class::cast).forEach(this::processServiceFactory);
    }

    private void processServiceFactory(TypeElement element) {
        try {
            String javaTypeName = Strings.canonicalClassName(element.getQualifiedName().toString());
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                ServiceFactory sf = annotationMirror.getAnnotationType().asElement().getAnnotation(ServiceFactory.class);
                if (sf == null) continue;
                String pvals = annotationMirror.getElementValues().values().iterator().next().getValue().toString();
                for (String pval : pvals.split(",")) {
                    Throwable throwable;
                    Writer w;
                    FileObject resource;
                    if ("#jdk#".equals(sf.value())) {
                        resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + pval.replace('.', '/'), element);
                        w = resource.openWriter();
                        throwable = null;
                        try {
                            w.append("# Generated by camel annotation processor\n");
                            w.append("class=").append(javaTypeName).append("\n");
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (w != null) {
                                if (throwable != null) {
                                    try {
                                        w.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    w.close();
                                }
                            }
                        }
                    }
                    resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/org/apache/camel/" + sf.value() + "/" + pval, element);
                    w = resource.openWriter();
                    throwable = null;
                    try {
                        w.append("# Generated by camel annotation processor\n");
                        w.append("class=").append(javaTypeName).append("\n");
                        for (AnnotationMirror annotationMirror2 : element.getAnnotationMirrors()) {
                            SubServiceFactory factory = annotationMirror2.getAnnotationType().asElement().getAnnotation(SubServiceFactory.class);
                            if (factory == null) continue;
                            String key = factory.value();
                            String val = annotationMirror2.getElementValues().values().iterator().next().getValue().toString();
                            w.append(key).append(".class=").append(val).append("\n");
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (w != null) {
                            if (throwable != null) {
                                try {
                                    w.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                w.close();
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

