/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jndi;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.camel.TestSupport;
import org.apache.camel.util.jndi.ExampleBean;

public class JndiTest
extends TestSupport {
    protected Context context;

    public static Context createInitialContext() throws Exception {
        InputStream in = JndiTest.class.getClassLoader().getResourceAsStream("jndi-example.properties");
        JndiTest.assertNotNull((String)"Cannot find jndi-example.properties on the classpath!", (Object)in);
        Properties properties = new Properties();
        properties.load(in);
        return new InitialContext(new Hashtable<Object, Object>(properties));
    }

    public void testLookupOfSimpleName() throws Exception {
        Object value = this.assertLookup("foo");
        JndiTest.assertEquals((String)"foo", (Object)"bar", (Object)value);
    }

    public void testLookupOfTypedObject() throws Exception {
        Object value = this.assertLookup("example");
        ExampleBean bean = this.assertIsInstanceOf(ExampleBean.class, value);
        JndiTest.assertEquals((String)"Bean.name", (String)"James", (String)bean.getName());
        JndiTest.assertEquals((String)"Bean.price", (Object)2.34, (Object)bean.getPrice());
        this.log.info((Object)("Found bean: " + bean));
    }

    protected Object assertLookup(String name) throws NamingException {
        Object value = this.context.lookup(name);
        JndiTest.assertNotNull((String)("Should have found JNDI entry: " + name + " in context: " + this.context), (Object)value);
        return value;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.context = JndiTest.createInitialContext();
    }
}

