/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExchangeHelperTest
extends TestCase {
    private static final transient Log LOG = LogFactory.getLog(ExchangeHelperTest.class);
    protected Exchange exchange;

    public void testValidProperty() throws Exception {
        String value = ExchangeHelper.getMandatoryProperty(this.exchange, "foo", String.class);
        ExchangeHelperTest.assertEquals((String)"foo property", (String)"123", (String)value);
    }

    public void testMissingProperty() throws Exception {
        try {
            String value = ExchangeHelper.getMandatoryProperty(this.exchange, "bar", String.class);
            ExchangeHelperTest.fail((String)("Should have failed but got: " + value));
        }
        catch (NoSuchPropertyException e) {
            LOG.debug((Object)("Caught expected: " + e), (Throwable)e);
        }
    }

    public void testPropertyOfIncompatibleType() throws Exception {
        try {
            List value = ExchangeHelper.getMandatoryProperty(this.exchange, "foo", List.class);
            ExchangeHelperTest.fail((String)("Should have failed but got: " + value));
        }
        catch (NoSuchPropertyException e) {
            LOG.debug((Object)("Caught expected: " + e), (Throwable)e);
        }
    }

    protected void setUp() throws Exception {
        this.exchange = new DefaultExchange(new DefaultCamelContext());
        this.exchange.setProperty("foo", 123);
    }
}

