/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.example;

import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ContentBasedRouteTest
extends SpringTestSupport {
    protected MockEndpoint matchedEndpoint;
    protected MockEndpoint notMatchedEndpoint;
    protected Object body = "<hello>world!</hello>";
    protected String header = "destination";

    public void testMatchesPredicate() throws Exception {
        this.matchedEndpoint.expectedMessageCount(1);
        this.notMatchedEndpoint.expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", this.body, this.header, (Object)"firstChoice");
        MockEndpoint.assertIsSatisfied(this.matchedEndpoint, this.notMatchedEndpoint);
    }

    public void testDoesNotMatchPredicate() throws Exception {
        this.matchedEndpoint.expectedMessageCount(0);
        this.notMatchedEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", this.body, this.header, (Object)"notMatchedValue");
        MockEndpoint.assertIsSatisfied(this.matchedEndpoint, this.notMatchedEndpoint);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.matchedEndpoint = this.getMockEndpoint("mock:matched");
        this.notMatchedEndpoint = this.getMockEndpoint("mock:notMatched");
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/example/contentBasedRoute.xml");
    }
}

