/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.config;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.model.FromType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteType;
import org.apache.camel.spring.config.CamelContextFactoryBeanTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlConfigTestSupport
extends TestSupport {
    protected static final transient Log LOG = LogFactory.getLog(CamelContextFactoryBeanTest.class);

    protected void assertValidContext(CamelContext context) {
        XmlConfigTestSupport.assertNotNull((String)"No context found!", (Object)context);
        List<RouteType> routes = context.getRouteDefinitions();
        LOG.debug((Object)("Found routes: " + routes));
        XmlConfigTestSupport.assertEquals((String)"One Route should be found", (int)1, (int)routes.size());
        for (RouteType route : routes) {
            List<FromType> inputs = route.getInputs();
            XmlConfigTestSupport.assertEquals((String)"Number of inputs", (int)1, (int)inputs.size());
            FromType fromType = inputs.get(0);
            XmlConfigTestSupport.assertEquals((String)"from URI", (String)"seda:test.a", (String)fromType.getEndpoint().getEndpointUri());
            List<ProcessorType<?>> outputs = route.getOutputs();
            XmlConfigTestSupport.assertEquals((String)"Number of outputs", (int)1, (int)outputs.size());
        }
    }
}

