/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpringTestSupport
extends ContextTestSupport {
    protected AbstractXmlApplicationContext applicationContext;

    protected abstract ClassPathXmlApplicationContext createApplicationContext();

    @Override
    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        SpringTestSupport.assertNotNull((String)"Should have created a valid spring context", (Object)this.applicationContext);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
    }

    public <T> T getMandatoryBean(Class<T> type, String name) {
        Object value = this.applicationContext.getBean(name);
        SpringTestSupport.assertNotNull((String)("No spring bean found for name <" + name + ">"), (Object)value);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        SpringTestSupport.fail((String)("Spring bean <" + name + "> is not an instanceof " + type.getName() + " but is of type " + ObjectHelper.className(value)));
        return null;
    }

    @Override
    protected void assertValidContext(CamelContext context) {
        super.assertValidContext(context);
        List<Route> routes = context.getRoutes();
        int routeCount = this.getExpectedRouteCount();
        if (routeCount > 0) {
            SpringTestSupport.assertNotNull((String)"Should have some routes defined", routes);
            SpringTestSupport.assertTrue((String)"Should have at least one route", (routes.size() >= routeCount ? 1 : 0) != 0);
        }
        this.log.debug((Object)("Camel Routes: " + routes));
    }

    protected int getExpectedRouteCount() {
        return 1;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext);
    }
}

