/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.camel.spring.example.DummyBean;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EndpointReferenceTest
extends SpringTestSupport {
    protected static Object body = "<hello>world!</hello>";

    public void testEndpointConfiguration() throws Exception {
        Endpoint endpoint = this.getMandatoryBean(Endpoint.class, "endpoint1");
        EndpointReferenceTest.assertEquals((String)"endpoint URI", (String)"direct:start", (String)endpoint.getEndpointUri());
        DummyBean dummyBean = this.getMandatoryBean(DummyBean.class, "mybean");
        EndpointReferenceTest.assertNotNull((String)"The bean should have an endpoint injected", (Object)dummyBean.getEndpoint());
        EndpointReferenceTest.assertEquals((String)"endpoint URI", (String)"direct:start", (String)dummyBean.getEndpoint().getEndpointUri());
        this.log.debug((Object)("Found dummy bean: " + dummyBean));
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:end");
        resultEndpoint.expectedBodiesReceived(body);
        this.template.sendBody("direct:start", body);
        resultEndpoint.assertIsSatisfied();
    }

    protected SpringCamelContext createCamelContext() {
        return (SpringCamelContext)this.applicationContext.getBean("camel");
    }

    public void testEndpointConfigurationAfterEnsuringThatTheStatementRouteBuilderWasCreated() throws Exception {
        String[] names;
        for (String name : names = this.applicationContext.getBeanDefinitionNames()) {
            this.log.debug((Object)("Found bean name: " + name));
        }
        this.testEndpointConfiguration();
    }

    protected void assertValidContext(SpringCamelContext context) {
        super.assertValidContext(context);
        List<Route> routes = context.getRoutes();
        EndpointReferenceTest.assertEquals((String)"Number of routes defined", (int)1, (int)routes.size());
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/endpointReference.xml");
    }
}

