/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class RoutingSlipTest
extends ContextTestSupport {
    protected static final String ANSWER = "answer";
    protected static final String ROUTING_SLIP_HEADER = "routingSlipHeader";

    public void testUpdatingOfRoutingSlipAllDefaults() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedHeaderReceived(ROUTING_SLIP_HEADER, "mock:y,mock:z");
        y.expectedHeaderReceived(ROUTING_SLIP_HEADER, "mock:z");
        z.expectedHeaderReceived(ROUTING_SLIP_HEADER, "");
        this.sendBody("direct:a", ROUTING_SLIP_HEADER, ",");
        this.assertMockEndpointsSatisifed();
    }

    public void testUpdatingOfRoutingSlipHeaderSet() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedHeaderReceived("aRoutingSlipHeader", "mock:y,mock:z");
        y.expectedHeaderReceived("aRoutingSlipHeader", "mock:z");
        z.expectedHeaderReceived("aRoutingSlipHeader", "");
        this.sendBody("direct:b", "aRoutingSlipHeader", ",");
        this.assertMockEndpointsSatisifed();
    }

    public void testUpdatingOfRoutingSlipHeaderAndDelimiterSet() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedHeaderReceived("aRoutingSlipHeader", "mock:y#mock:z");
        y.expectedHeaderReceived("aRoutingSlipHeader", "mock:z");
        z.expectedHeaderReceived("aRoutingSlipHeader", "");
        this.sendBody("direct:c", "aRoutingSlipHeader", "#");
        this.assertMockEndpointsSatisifed();
    }

    public void testMessagePassingThrough() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        this.sendBody("direct:a", ROUTING_SLIP_HEADER, ",");
        this.assertMockEndpointsSatisifed();
    }

    public void testEmptyRoutingSlip() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        this.sendBodyWithEmptyRoutingSlip();
        this.assertMockEndpointsSatisifed();
    }

    public void testNoRoutingSlip() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        this.sendBodyWithNoRoutingSlip();
        this.assertMockEndpointsSatisifed();
    }

    protected void sendBody(String endpoint, String header, String delimiter) {
        this.template.sendBodyAndHeader(endpoint, (Object)ANSWER, header, (Object)("mock:x" + delimiter + "mock:y" + delimiter + "mock:z"));
    }

    protected void sendBodyWithEmptyRoutingSlip() {
        this.template.sendBodyAndHeader("direct:a", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"");
    }

    protected void sendBodyWithNoRoutingSlip() {
        this.template.sendBody("direct:a", (Object)ANSWER);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorType)this.from("direct:a").routingSlip()).to("mock:end");
                this.from("direct:b").routingSlip("aRoutingSlipHeader");
                this.from("direct:c").routingSlip("aRoutingSlipHeader", "#");
            }
        };
    }
}

