/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import java.util.Map;
import javax.naming.Context;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Headers;
import org.apache.camel.OutHeaders;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.jndi.JndiContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RoutingSlipDataModificationTest
extends ContextTestSupport {
    protected static final String ANSWER = "answer";
    protected static final String ROUTING_SLIP_HEADER = "routingSlipHeader";
    private static final transient Log LOG = LogFactory.getLog(RoutingSlipDataModificationTest.class);
    protected MyBean myBean = new MyBean("routingSlipHeader");

    public void testModificationOfDataAlongRoute() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(ANSWER);
        y.expectedBodiesReceived("answeranswer");
        z.expectedBodiesReceived("answeranswer");
        this.sendBody();
        this.assertMockEndpointsSatisifed();
    }

    protected void sendBody() {
        this.template.sendBodyAndHeader("direct:a", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:x,bean:myBean?method=modifyData,mock:y,mock:z");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object lookedUpBean = this.context.getRegistry().lookup("myBean");
        RoutingSlipDataModificationTest.assertSame((String)"Lookup of 'myBean' should return same object!", (Object)this.myBean, (Object)lookedUpBean);
    }

    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").routingSlip(RoutingSlipDataModificationTest.ROUTING_SLIP_HEADER);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyBean {
        private String routingSlipHeader;

        public MyBean() {
        }

        public MyBean(String routingSlipHeader) {
            this.routingSlipHeader = routingSlipHeader;
        }

        public String modifyData(@Body String body, @Headers Map<String, Object> headers, @OutHeaders Map<String, Object> outHeaders) {
            outHeaders.put(this.routingSlipHeader, headers.get(this.routingSlipHeader));
            return body + body;
        }
    }
}

