/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.io.StringReader;
import java.util.LinkedList;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.converter.stream.StreamCache;
import org.apache.camel.model.InterceptorRef;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.interceptor.StreamCachingInterceptor;

public class StreamCachingInterceptorTest
extends ContextTestSupport {
    private MockEndpoint a;
    private MockEndpoint b;

    public void testConvertStreamSourceWithRouteBuilderStreamCaching() throws Exception {
        this.a.expectedMessageCount(1);
        StreamSource message = new StreamSource(new StringReader("<hello>world!</hello>"));
        this.template.sendBody("direct:a", (Object)message);
        this.assertMockEndpointsSatisifed();
        StreamCachingInterceptorTest.assertTrue((boolean)(this.a.assertExchangeReceived(0).getIn().getBody() instanceof StreamCache));
    }

    public void testConvertStreamSourceWithRouteOnlyStreamCaching() throws Exception {
        this.b.expectedMessageCount(1);
        StreamSource message = new StreamSource(new StringReader("<hello>world!</hello>"));
        this.template.sendBody("direct:b", (Object)message);
        this.assertMockEndpointsSatisifed();
        StreamCachingInterceptorTest.assertTrue((boolean)(this.b.assertExchangeReceived(0).getIn().getBody() instanceof StreamCache));
    }

    public void testIgnoreAlreadyRereadable() throws Exception {
        this.a.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)"<hello>world!</hello>");
        this.assertMockEndpointsSatisifed();
        StreamCachingInterceptorTest.assertTrue((boolean)(this.a.assertExchangeReceived(0).getIn().getBody() instanceof String));
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.a = this.getMockEndpoint("mock:a");
        this.b = this.getMockEndpoint("mock:b");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").streamCaching().to("mock:a");
                this.streamCaching();
                this.from("direct:b").to("mock:b");
            }
        };
    }

    public void testNoStreamCaching() throws Exception {
        LinkedList<InterceptorType> interceptors = new LinkedList<InterceptorType>();
        InterceptorRef streamCache = new InterceptorRef(new StreamCachingInterceptor());
        interceptors.add(streamCache);
        interceptors.add(new InterceptorRef(new DelegateProcessor()));
        StreamCachingInterceptor.noStreamCaching(interceptors);
        StreamCachingInterceptorTest.assertEquals((int)1, (int)interceptors.size());
        StreamCachingInterceptorTest.assertFalse((boolean)interceptors.contains(streamCache));
    }
}

