/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelTemplate;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregatorType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlbertoAggregatorTest
extends ContextTestSupport {
    private static final String SURNAME_HEADER = "surname";
    private static final String TYPE_HEADER = "type";
    private static final String BROTHERS_TYPE = "brothers";
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void testAggregator() throws Exception {
        String allNames = "Harpo Marx,Fiodor Karamazov,Chico Marx,Ivan Karamazov,Groucho Marx,Alexei Karamazov,Dimitri Karamazov";
        ArrayList<String> marxBrothers = new ArrayList<String>();
        marxBrothers.add("Harpo");
        marxBrothers.add("Chico");
        marxBrothers.add("Groucho");
        ArrayList<String> karamazovBrothers = new ArrayList<String>();
        karamazovBrothers.add("Fiodor");
        karamazovBrothers.add("Ivan");
        karamazovBrothers.add("Alexei");
        karamazovBrothers.add("Dimitri");
        HashMap<String, ArrayList<String>> allBrothers = new HashMap<String, ArrayList<String>>();
        allBrothers.put("Marx", marxBrothers);
        allBrothers.put("Karamazov", karamazovBrothers);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.expectedBodiesReceived(allBrothers);
        CamelTemplate template = new CamelTemplate(this.context);
        template.sendBody("direct:start", (Object)allNames);
        this.assertMockEndpointsSatisifed();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){
            AggregationStrategy surnameAggregator = new AggregationStrategy(){

                public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                    this.debugIn("Surname Aggregator", oldExchange, newExchange);
                    Message oldIn = oldExchange.getIn();
                    Message newIn = newExchange.getIn();
                    List<String> brothers = null;
                    if (oldIn.getBody() instanceof List) {
                        brothers = oldIn.getBody(List.class);
                        brothers.add(newIn.getBody(String.class));
                    } else {
                        brothers = new ArrayList();
                        brothers.add(oldIn.getBody(String.class));
                        brothers.add(newIn.getBody(String.class));
                        oldExchange.getIn().setBody(brothers);
                    }
                    this.debugOut("Surname Aggregator", oldExchange);
                    return oldExchange;
                }
            };
            AggregationStrategy brothersAggregator = new AggregationStrategy(){

                public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                    this.debugIn("Brothers Aggregator", oldExchange, newExchange);
                    Message oldIn = oldExchange.getIn();
                    Message newIn = newExchange.getIn();
                    Map<String, List> brothers = null;
                    if (oldIn.getBody() instanceof Map) {
                        brothers = oldIn.getBody(Map.class);
                        brothers.put(newIn.getHeader(AlbertoAggregatorTest.SURNAME_HEADER, String.class), newIn.getBody(List.class));
                    } else {
                        brothers = new HashMap();
                        brothers.put(oldIn.getHeader(AlbertoAggregatorTest.SURNAME_HEADER, String.class), oldIn.getBody(List.class));
                        brothers.put(newIn.getHeader(AlbertoAggregatorTest.SURNAME_HEADER, String.class), newIn.getBody(List.class));
                        oldExchange.getIn().setBody(brothers);
                    }
                    this.debugOut("Brothers Aggregator", oldExchange);
                    return oldExchange;
                }
            };

            private void debugIn(String stringId, Exchange oldExchange, Exchange newExchange) {
                AlbertoAggregatorTest.this.log.debug((Object)(stringId + " old headers in: " + oldExchange.getIn().getHeaders()));
                AlbertoAggregatorTest.this.log.debug((Object)(stringId + " old body in: " + oldExchange.getIn().getBody()));
                AlbertoAggregatorTest.this.log.debug((Object)(stringId + " new headers in: " + newExchange.getIn().getHeaders()));
                AlbertoAggregatorTest.this.log.debug((Object)(stringId + " new body in: " + newExchange.getIn().getBody()));
            }

            private void debugOut(String stringId, Exchange exchange) {
                AlbertoAggregatorTest.this.log.debug((Object)(stringId + " old headers out: " + exchange.getIn().getHeaders()));
                AlbertoAggregatorTest.this.log.debug((Object)(stringId + " old body out: " + exchange.getIn().getBody()));
            }

            public void configure() throws Exception {
                ((ProcessorType)this.from("direct:start").splitter(AlbertoAggregatorTest.this.bodyAs(String.class).tokenize(",")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String[] parts = exchange.getIn().getBody(String.class).split(" ");
                        exchange.getIn().setBody(parts[0]);
                        exchange.getIn().setHeader(AlbertoAggregatorTest.SURNAME_HEADER, parts[1]);
                    }
                })).to("direct:joinSurnames");
                ((ProcessorType)this.from("direct:joinSurnames").aggregator(this.header(AlbertoAggregatorTest.SURNAME_HEADER), this.surnameAggregator).setHeader(AlbertoAggregatorTest.TYPE_HEADER, this.constant(AlbertoAggregatorTest.BROTHERS_TYPE))).to("direct:joinBrothers");
                AggregatorType agg = this.from("direct:joinBrothers").aggregator(this.header(AlbertoAggregatorTest.TYPE_HEADER), this.brothersAggregator);
                agg.setBatchTimeout(5000L);
                ((ProcessorType)((ProcessorType)agg.removeHeader(AlbertoAggregatorTest.SURNAME_HEADER)).removeHeader(AlbertoAggregatorTest.TYPE_HEADER)).to("mock:result");
            }
        };
    }
}

