/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryType;
import org.apache.camel.processor.MyValidator;

public class ValidationTest
extends ContextTestSupport {
    protected Processor validator = new MyValidator();
    protected MockEndpoint validEndpoint;
    protected MockEndpoint invalidEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.invalidEndpoint.expectedMessageCount(0);
        Object result = this.template.sendBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        MockEndpoint.assertIsSatisfied(this.validEndpoint, this.invalidEndpoint);
        ValidationTest.assertEquals((Object)"validResult", (Object)result);
    }

    public void testInvalidMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.validEndpoint.expectedMessageCount(0);
        Object result = this.template.sendBodyAndHeader("direct:start", (Object)"<invalid/>", "foo", (Object)"notMatchedHeaderValue");
        MockEndpoint.assertIsSatisfied(this.validEndpoint, this.invalidEndpoint);
        ValidationTest.assertEquals((Object)"invalidResult", (Object)result);
    }

    public void testinvalidThenValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(2);
        this.invalidEndpoint.expectedMessageCount(1);
        Object result = this.template.sendBodyAndHeader("direct:start", (Object)"<invalid/>", "foo", (Object)"notMatchedHeaderValue");
        ValidationTest.assertEquals((Object)"invalidResult", (Object)result);
        result = this.template.sendBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        ValidationTest.assertEquals((Object)"validResult", (Object)result);
        result = this.template.sendBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        ValidationTest.assertEquals((Object)"validResult", (Object)result);
        MockEndpoint.assertIsSatisfied(this.validEndpoint, this.invalidEndpoint);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.validEndpoint.whenAnyExchangeReceived(ProcessorBuilder.setOutBody(Builder.constant("validResult")));
        this.invalidEndpoint.whenAnyExchangeReceived(ProcessorBuilder.setOutBody(Builder.constant("invalidResult")));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryType)((TryType)this.from("direct:start").tryBlock().process(ValidationTest.this.validator)).to("mock:valid")).handle(ValidationException.class).to("mock:invalid");
            }
        };
    }
}

