/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class TransformTest
extends ContextTestSupport {
    protected MockEndpoint resultEndpoint;

    public void testSendingAMessageUsingMulticastReceivesItsOwnExchange() throws Exception {
        this.resultEndpoint.expectedBodiesReceived("Hello World!");
        this.sendBody("direct:start", "Hello");
        this.resultEndpoint.assertIsSatisfied();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorType)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        Message in = exchange.getIn();
                        in.setBody(in.getBody(String.class) + " World!");
                    }
                })).to("mock:result");
            }
        };
    }
}

