/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class StreamResequencerTest
extends ContextTestSupport {
    protected MockEndpoint resultEndpoint;

    public void sendBodyAndHeader(String endpointUri, final Object body, final String headerName, final Object headerValue) {
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader(headerName, headerValue);
                in.setHeader("testCase", StreamResequencerTest.this.getName());
            }
        });
    }

    public void testSendMessagesInWrongOrderButReceiveThemInCorrectOrder() throws Exception {
        this.resultEndpoint.expectedBodiesReceived("msg1", "msg2", "msg3", "msg4");
        this.sendBodyAndHeader("direct:start", "msg4", "seqnum", 4L);
        this.sendBodyAndHeader("direct:start", "msg1", "seqnum", 1L);
        this.sendBodyAndHeader("direct:start", "msg3", "seqnum", 3L);
        this.sendBodyAndHeader("direct:start", "msg2", "seqnum", 2L);
        this.resultEndpoint.assertIsSatisfied();
        List<Exchange> list = this.resultEndpoint.getReceivedExchanges();
        for (Exchange exchange : list) {
            this.log.debug((Object)("Received: " + exchange));
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").resequencer((Expression<Exchange>)this.header("seqnum")).stream().to("mock:result");
            }
        };
    }
}

