/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.ExpressionAdapter;

public class SetHeaderUsingDslExpressionsTest
extends ContextTestSupport {
    protected String body = "<person name='James' city='London'/>";
    protected MockEndpoint expected;

    public void testUseConstant() throws Exception {
        this.context.addRoutes(new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").setHeader("foo").constant("ABC").to("mock:result");
            }
        });
        this.template.sendBodyAndHeader("direct:start", (Object)this.body, "bar", (Object)"ABC");
        this.assertMockEndpointsSatisifed();
    }

    public void testUseConstantParameter() throws Exception {
        this.context.addRoutes(new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorType)this.from("direct:start").setHeader("foo", "ABC")).to("mock:result");
            }
        });
        this.template.sendBodyAndHeader("direct:start", (Object)this.body, "bar", (Object)"ABC");
        this.assertMockEndpointsSatisifed();
    }

    public void testUseExpression() throws Exception {
        this.context.addRoutes(new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").setHeader("foo").expression(new ExpressionAdapter(){

                    public Object evaluate(Exchange exchange) {
                        return "ABC";
                    }
                }).to("mock:result");
            }
        });
        this.template.sendBodyAndHeader("direct:start", (Object)this.body, "bar", (Object)"ABC");
        this.assertMockEndpointsSatisifed();
    }

    public void testUseHeaderExpression() throws Exception {
        this.context.addRoutes(new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").setHeader("foo").header("bar").to("mock:result");
            }
        });
        this.template.sendBodyAndHeader("direct:start", (Object)this.body, "bar", (Object)"ABC");
        this.assertMockEndpointsSatisifed();
    }

    public void testUseBodyExpresion() throws Exception {
        this.context.addRoutes(new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").setHeader("foo").body().to("mock:result");
            }
        });
        this.template.sendBody("direct:start", (Object)"ABC");
        this.assertMockEndpointsSatisifed();
    }

    public void testUseBodyAsTypeExpresion() throws Exception {
        this.context.addRoutes(new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").setHeader("foo").body(String.class).to("mock:result");
            }
        });
        this.template.sendBody("direct:start", (Object)"ABC".getBytes());
        this.assertMockEndpointsSatisifed();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.expected = this.getMockEndpoint("mock:result");
        this.expected.message(0).header("foo").isEqualTo("ABC");
    }
}

