/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class ResequencerTest
extends ContextTestSupport {
    protected Endpoint<Exchange> startEndpoint;
    protected MockEndpoint resultEndpoint;

    public void testSendMessagesInWrongOrderButReceiveThemInCorrectOrder() throws Exception {
        this.resultEndpoint.expectedBodiesReceived("Guillaume", "Hiram", "James", "Rob");
        this.sendBodies("direct:start", "Rob", "Hiram", "Guillaume", "James");
        this.resultEndpoint.assertIsSatisfied();
        List<Exchange> list = this.resultEndpoint.getReceivedExchanges();
        for (Exchange exchange : list) {
            this.log.debug((Object)("Received: " + exchange));
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").resequencer((Expression<Exchange>)this.body()).to("mock:result");
            }
        };
    }
}

