/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class MulticastStreamCachingTest
extends ContextTestSupport {
    protected Endpoint<Exchange> startEndpoint;
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    public void testSendingAMessageUsingMulticastConvertsToReReadable() throws Exception {
        this.x.expectedBodiesReceived("<input/>+output");
        this.y.expectedBodiesReceived("<input/>+output");
        this.z.expectedBodiesReceived("<input/>+output");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(new StreamSource(new StringReader("<input/>")));
                in.setHeader("foo", "bar");
            }
        });
        this.assertMockEndpointsSatisifed();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        final Processor processor = new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                String body = in.getBody(String.class);
                in.setBody(body + "+output");
            }
        };
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").streamCaching().multicast().to("direct:x", "direct:y", "direct:z");
                ((ProcessorType)this.from("direct:x").process(processor)).to("mock:x");
                ((ProcessorType)this.from("direct:y").process(processor)).to("mock:y");
                ((ProcessorType)this.from("direct:z").process(processor)).to("mock:z");
            }
        };
    }
}

