/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;

public class MethodFilterTest
extends ContextTestSupport {
    public void testSendMatchingMessage() throws Exception {
        String body = "<person name='James' city='London'/>";
        this.getMockEndpoint("mock:result").expectedBodiesReceived(body);
        this.template.sendBodyAndHeader("direct:start", (Object)body, "foo", (Object)"London");
        this.assertMockEndpointsSatisifed();
    }

    public void testSendNotMatchingMessage() throws Exception {
        String body = "<person name='Hiram' city='Tampa'/>";
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)body, "foo", (Object)"Tampa");
        this.assertMockEndpointsSatisifed();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").filter().method("myBean", "matches").to("mock:result");
            }
        };
    }

    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("myBean", (Object)new MyBean());
        return context;
    }

    public static class MyBean {
        public boolean matches(@Header(name="foo") String location) {
            return "London".equals(location);
        }
    }
}

