/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceType;

public class JoinRoutesTest
extends ContextTestSupport {
    protected Endpoint<Exchange> startEndpoint;
    protected MockEndpoint resultEndpoint;

    public void testMessagesThroughDifferentRoutes() throws Exception {
        this.resultEndpoint.expectedBodiesReceived("one", "two", "three");
        this.sendMessage("bar", "one");
        this.sendMessage("cheese", "two");
        this.sendMessage("somethingUndefined", "three");
        this.resultEndpoint.assertIsSatisfied();
    }

    protected void sendMessage(final Object headerValue, final Object body) throws Exception {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("foo", headerValue);
            }
        });
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:a");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceType)((ChoiceType)this.from("direct:a").choice().when(this.header("foo").isEqualTo("bar")).to("direct:b")).when(this.header("foo").isEqualTo("cheese")).to("direct:c")).otherwise().to("direct:d");
                this.from("direct:b").to("mock:result");
                this.from("direct:c").to("mock:result");
                this.from("direct:d").to("mock:result");
            }
        };
    }
}

