/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class DelayerTest
extends ContextTestSupport {
    public void testSendingMessageGetsDelayed() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(0);
        this.template.sendBodyAndHeader("seda:a", (Object)"<hello>world!</hello>", "JMSTimestamp", (Object)System.currentTimeMillis());
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.assertIsSatisfied();
        this.template.sendBody("seda:b", (Object)"<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.assertIsSatisfied();
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:a").delayer(this.header("JMSTimestamp"), 3000L).to("mock:result");
                this.from("seda:b").delayer(3000L).to("mock:result");
            }
        };
    }
}

