/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.LoggingLevel;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeadLetterChannel
extends ErrorHandlerSupport
implements AsyncProcessor {
    public static final String REDELIVERY_COUNTER = "org.apache.camel.RedeliveryCounter";
    public static final String REDELIVERED = "org.apache.camel.Redelivered";
    public static final String EXCEPTION_CAUSE_PROPERTY = "CamelCauseException";
    private static final transient Log LOG = LogFactory.getLog(DeadLetterChannel.class);
    private static final String FAILURE_HANDLED_PROPERTY = DeadLetterChannel.class.getName() + ".FAILURE_HANDLED";
    private Processor output;
    private Processor deadLetter;
    private AsyncProcessor outputAsync;
    private RedeliveryPolicy redeliveryPolicy;
    private Logger logger;

    public DeadLetterChannel(Processor output, Processor deadLetter) {
        this(output, deadLetter, new RedeliveryPolicy(), DeadLetterChannel.createDefaultLogger());
    }

    public DeadLetterChannel(Processor output, Processor deadLetter, RedeliveryPolicy redeliveryPolicy, Logger logger) {
        this.deadLetter = deadLetter;
        this.output = output;
        this.outputAsync = AsyncProcessorTypeConverter.convert(output);
        this.redeliveryPolicy = redeliveryPolicy;
        this.logger = logger;
    }

    public static <E extends Exchange> Logger createDefaultLogger() {
        return new Logger(LOG, LoggingLevel.ERROR);
    }

    public String toString() {
        return "DeadLetterChannel[" + this.output + ", " + this.deadLetter + ", " + this.redeliveryPolicy + "]";
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.process(exchange, callback, new RedeliveryData());
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback, final RedeliveryData data) {
        do {
            if (!this.isRunAllowed()) {
                if (exchange.getException() == null) {
                    exchange.setException(new RejectedExecutionException());
                }
                callback.done(data.sync);
                return data.sync;
            }
            if (exchange.getException() != null) {
                Throwable e = exchange.getException();
                exchange.setException(null);
                this.logger.log("Failed delivery for exchangeId: " + exchange.getExchangeId() + ". On delivery attempt: " + data.redeliveryCounter + " caught: " + e, e);
                data.redeliveryCounter = this.incrementRedeliveryCounter(exchange, e);
                ExceptionType exceptionPolicy = this.getExceptionPolicy(exchange, e);
                if (exceptionPolicy != null) {
                    data.currentRedeliveryPolicy = exceptionPolicy.createRedeliveryPolicy(data.currentRedeliveryPolicy);
                    Processor processor = exceptionPolicy.getErrorHandler();
                    if (processor != null) {
                        data.failureProcessor = processor;
                    }
                }
            }
            if (!data.currentRedeliveryPolicy.shouldRedeliver(data.redeliveryCounter)) {
                DeadLetterChannel.setFailureHandled(exchange, true);
                AsyncProcessor afp = AsyncProcessorTypeConverter.convert(data.failureProcessor);
                boolean sync = afp.process(exchange, new AsyncCallback(){

                    public void done(boolean sync) {
                        DeadLetterChannel.restoreExceptionOnExchange(exchange);
                        callback.done(data.sync);
                    }
                });
                DeadLetterChannel.restoreExceptionOnExchange(exchange);
                this.logger.log("Failed delivery for exchangeId: " + exchange.getExchangeId() + ". Handled by the failure processor: " + data.failureProcessor);
                return sync;
            }
            if (data.redeliveryCounter > 0) {
                data.redeliveryDelay = data.currentRedeliveryPolicy.getRedeliveryDelay(data.redeliveryDelay);
                this.sleep(data.redeliveryDelay);
            }
            exchange.setProperty(EXCEPTION_CAUSE_PROPERTY, exchange.getException());
            exchange.setException(null);
            boolean sync = this.outputAsync.process(exchange, new AsyncCallback(){

                public void done(boolean sync) {
                    if (sync) {
                        return;
                    }
                    data.sync = false;
                    if (exchange.getException() != null) {
                        DeadLetterChannel.this.process(exchange, callback, data);
                    } else {
                        callback.done(sync);
                    }
                }
            });
            if (sync) continue;
            return false;
        } while (exchange.getException() != null && !DeadLetterChannel.isFailureHandled(exchange));
        callback.done(true);
        return true;
    }

    public static boolean isFailureHandled(Exchange exchange) {
        return exchange.getProperty(FAILURE_HANDLED_PROPERTY) != null;
    }

    public static void setFailureHandled(Exchange exchange, boolean isHandled) {
        if (isHandled) {
            exchange.setProperty(FAILURE_HANDLED_PROPERTY, exchange.getException());
            exchange.setException(null);
        } else {
            exchange.setException(exchange.getProperty(FAILURE_HANDLED_PROPERTY, Throwable.class));
            exchange.removeProperty(FAILURE_HANDLED_PROPERTY);
        }
    }

    public static void restoreExceptionOnExchange(Exchange exchange) {
        exchange.setException(exchange.getProperty(FAILURE_HANDLED_PROPERTY, Throwable.class));
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    public Processor getOutput() {
        return this.output;
    }

    public Processor getDeadLetter() {
        return this.deadLetter;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected int incrementRedeliveryCounter(Exchange exchange, Throwable e) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader(REDELIVERY_COUNTER, Integer.class);
        int next = 1;
        if (counter != null) {
            next = counter + 1;
        }
        in.setHeader(REDELIVERY_COUNTER, next);
        in.setHeader(REDELIVERED, true);
        exchange.setException(e);
        return next;
    }

    protected void sleep(long redeliveryDelay) {
        block4: {
            if (redeliveryDelay > 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Sleeping for: " + redeliveryDelay + " millis until attempting redelivery"));
                }
                try {
                    Thread.sleep(redeliveryDelay);
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)("Thread interupted: " + e), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.output, this.deadLetter);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.deadLetter, this.output);
    }

    static /* synthetic */ RedeliveryPolicy access$000(DeadLetterChannel x0) {
        return x0.redeliveryPolicy;
    }

    static /* synthetic */ Processor access$100(DeadLetterChannel x0) {
        return x0.deadLetter;
    }

    private class RedeliveryData {
        int redeliveryCounter;
        long redeliveryDelay;
        boolean sync = true;
        RedeliveryPolicy currentRedeliveryPolicy = DeadLetterChannel.access$000(DeadLetterChannel.this);
        Processor failureProcessor = DeadLetterChannel.access$100(DeadLetterChannel.this);

        private RedeliveryData() {
        }
    }
}

