/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Header;
import org.apache.camel.Processor;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.MyValidator;
import org.apache.camel.util.jndi.JndiContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanWithExceptionTest
extends ContextTestSupport {
    protected Processor validator = new MyValidator();
    protected MockEndpoint validEndpoint;
    protected MockEndpoint invalidEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        MockEndpoint.assertIsSatisfied(this.validEndpoint, this.invalidEndpoint);
    }

    public void testInvalidMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"<invalid/>", "foo", (Object)"notMatchedHeaderValue");
        MockEndpoint.assertIsSatisfied(this.validEndpoint, this.invalidEndpoint);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
    }

    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)new ValidationBean());
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.exception(ValidationException.class).to("mock:invalid");
                ((ProcessorType)this.from("direct:start").beanRef("myBean")).to("mock:valid");
            }
        };
    }

    public static class ValidationBean {
        private static final transient Log LOG = LogFactory.getLog(ValidationBean.class);

        public void someMethod(String body, @Header(name="foo") String header) throws ValidationException {
            if (!"bar".equals(header)) {
                throw new ValidationException(null, "Invalid header foo: " + header);
            }
            LOG.info((Object)("someMethod() called with valid header and body: " + body));
        }
    }
}

