/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import junit.framework.Assert;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.jndi.JndiContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanRouteTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();

    public void testSendingMessageWithMethodNameHeader() throws Exception {
        String expectedBody = "Wobble";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody, "org.apache.camel.MethodName", (Object)"read");
        BeanRouteTest.assertEquals((String)("bean received correct value for: " + this.myBean), (String)expectedBody, (String)this.myBean.body);
    }

    public void testSendingMessageWithMethodNameHeaderWithMoreVerboseCoe() throws Exception {
        String expectedBody = "Wibble";
        this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody("Wibble");
                in.setHeader("org.apache.camel.MethodName", "read");
            }
        });
        BeanRouteTest.assertEquals((String)"bean received correct value", (String)"Wibble", (String)this.myBean.body);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object lookedUpBean = this.context.getRegistry().lookup("myBean");
        BeanRouteTest.assertSame((String)"Lookup of 'myBean' should return same object!", (Object)this.myBean, (Object)lookedUpBean);
    }

    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").beanRef("myBean");
            }
        };
    }

    public static class MyBean {
        private static AtomicInteger counter = new AtomicInteger(0);
        public String body;
        private int id = counter.incrementAndGet();

        public String toString() {
            return "MyBean:" + this.id;
        }

        public void read(String body) {
            this.body = body;
            LOG.info((Object)("read() method on " + this + " with body: " + body));
        }

        public void wrongMethod(String body) {
            Assert.fail((String)("wrongMethod() called with: " + body));
        }
    }
}

