/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Collection;
import javax.management.JMException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.management.CamelNamingStrategy;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.management.ManagedEndpoint;
import org.apache.camel.management.ManagedRoute;
import org.apache.camel.management.ManagedService;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.spi.InstrumentationAgent;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationLifecycleStrategy
implements LifecycleStrategy {
    private static final transient Log LOG = LogFactory.getLog(InstrumentationProcessor.class);
    private InstrumentationAgent agent;
    private CamelNamingStrategy namingStrategy;

    public InstrumentationLifecycleStrategy(InstrumentationAgent agent) {
        this.agent = agent;
        this.setNamingStrategy(agent.getNamingStrategy());
    }

    @Override
    public void onContextCreate(CamelContext context) {
        if (context instanceof DefaultCamelContext) {
            try {
                DefaultCamelContext dc = (DefaultCamelContext)context;
                ManagedService ms = new ManagedService(dc);
                this.agent.register(ms, this.getNamingStrategy().getObjectName(dc));
            }
            catch (JMException e) {
                LOG.warn((Object)"Could not register CamelContext MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onEndpointAdd(Endpoint<? extends Exchange> endpoint) {
        try {
            ManagedEndpoint me = new ManagedEndpoint(endpoint);
            this.agent.register(me, this.getNamingStrategy().getObjectName(me));
        }
        catch (JMException e) {
            LOG.warn((Object)"Could not register Endpoint MBean", (Throwable)e);
        }
    }

    @Override
    public void onRoutesAdd(Collection<Route> routes) {
        for (Route route : routes) {
            try {
                ManagedRoute mr = new ManagedRoute(route);
                this.agent.register(mr, this.getNamingStrategy().getObjectName(mr));
            }
            catch (JMException e) {
                LOG.warn((Object)"Could not register Route MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onServiceAdd(CamelContext context, Service service) {
        if (service instanceof ServiceSupport) {
            try {
                ManagedService ms = new ManagedService((ServiceSupport)service);
                this.agent.register(ms, this.getNamingStrategy().getObjectName(context, ms));
            }
            catch (JMException e) {
                LOG.warn((Object)"Could not register Service MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onRouteContextCreate(RouteContext routeContext) {
        PerformanceCounter mc = new PerformanceCounter();
        routeContext.getRoute().intercept(new InstrumentationProcessor(mc));
        try {
            this.agent.register(mc, this.getNamingStrategy().getObjectName(routeContext.getCamelContext(), mc, routeContext));
        }
        catch (JMException e) {
            LOG.warn((Object)"Could not register Counter MBean", (Throwable)e);
        }
    }

    public CamelNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(CamelNamingStrategy strategy) {
        this.namingStrategy = strategy;
    }
}

