/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class SetHeaderIssueTest
extends ContextTestSupport {
    protected Endpoint<Exchange> startEndpoint;
    protected MockEndpoint resultEndpoint;
    protected String matchingBody = "<person xmlns='urn:cheese' name='James' city='London'/>";
    protected String notMatchingBody = "<person xmlns='urn:cheese' name='Hiram' city='Tampa'/>";

    public void testSendMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(1);
        this.sendBody("direct:start", this.matchingBody);
        this.resultEndpoint.assertIsSatisfied();
    }

    public void testSendNotMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(0);
        this.sendBody("direct:start", this.notMatchingBody);
        this.resultEndpoint.assertIsSatisfied();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Namespaces ns = new Namespaces("foo", "urn:cheese");
                ((ProcessorType)this.from("direct:start").unmarshal().string().setHeader("foo", ns.xpath("/foo:person[@name='James']"))).filter(ns.xpath("/foo:person[@name='James']")).to("mock:result");
            }
        };
    }
}

