/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class ExceptionTest
extends ContextTestSupport {
    public void testExceptionWithoutHandler() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<body/>");
        this.assertMockEndpointsSatisifed();
    }

    public void testExceptionWithHandler() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        MockEndpoint exceptionEndpoint = this.getMockEndpoint("mock:exception");
        exceptionEndpoint.expectedMessageCount(1);
        resultEndpoint.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<body/>");
        this.assertMockEndpointsSatisifed();
    }

    public void testExceptionWithLongHandler() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        MockEndpoint exceptionEndpoint = this.getMockEndpoint("mock:exception");
        exceptionEndpoint.expectedBodiesReceived("<handled/>");
        resultEndpoint.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<body/>");
        this.assertMockEndpointsSatisifed();
    }

    public void testLongRouteWithHandler() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        MockEndpoint exceptionEndpoint = this.getMockEndpoint("mock:exception");
        exceptionEndpoint.expectedMessageCount(1);
        resultEndpoint.expectedMessageCount(0);
        this.template.sendBody("direct:start2", (Object)"<body/>");
        this.assertMockEndpointsSatisifed();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        final Processor exceptionThrower = new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody("<exception/>");
                throw new IllegalArgumentException("Exception thrown intentionally.");
            }
        };
        return new RouteBuilder(){

            public void configure() {
                if (ExceptionTest.this.getName().endsWith("WithLongHandler")) {
                    ExceptionTest.this.log.debug((Object)"Using long exception handler");
                    ((ProcessorType)this.exception(IllegalArgumentException.class).setBody(this.constant("<handled/>"))).to("mock:exception");
                } else if (ExceptionTest.this.getName().endsWith("WithHandler")) {
                    ExceptionTest.this.log.debug((Object)"Using exception handler");
                    this.exception(IllegalArgumentException.class).to("mock:exception");
                }
                ((ProcessorType)this.from("direct:start").process(exceptionThrower)).to("mock:result");
                ((ProcessorType)this.from("direct:start2").to("direct:intermediate")).to("mock:result");
                ((ProcessorType)((ProcessorType)this.from("direct:intermediate").setBody(this.constant("<some-value/>"))).process(exceptionThrower)).to("mock:result");
            }
        };
    }
}

