/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cxf;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.ProtocolException;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.PingMeFault;
import org.apache.hello_world_soap_http.SOAPService;
import org.apache.hello_world_soap_http.types.FaultDetail;

public final class Client {
    private static final QName SERVICE_NAME = new QName("http://apache.org/hello_world_soap_http", "SOAPService");
    private String wsdlLocation;
    private SOAPService soapService;

    public Client(String wsdl) throws MalformedURLException {
        File wsdlFile;
        URL wsdlURL = null;
        if (wsdl != null) {
            this.wsdlLocation = wsdl;
        }
        wsdlURL = (wsdlFile = new File(this.wsdlLocation)).exists() ? wsdlFile.toURL() : new URL(this.wsdlLocation);
        this.soapService = new SOAPService(wsdlURL, SERVICE_NAME);
    }

    public void invoke() throws Exception {
        System.out.println("Acquiring router port ...");
        Greeter port = this.soapService.getSoapOverHttpRouter();
        System.out.println("Invoking sayHi...");
        String resp = port.sayHi();
        System.out.println("Server responded with: " + resp);
        System.out.println();
        System.out.println("Invoking greetMe...");
        resp = port.greetMe(System.getProperty("user.name"));
        System.out.println("Server responded with: " + resp);
        System.out.println();
        System.out.println("Invoking greetMe with invalid length string, expecting exception...");
        try {
            resp = port.greetMe("Invoking greetMe with invalid length string, expecting exception...");
        }
        catch (ProtocolException e) {
            System.out.println("Expected exception has occurred: " + ((Object)((Object)e)).getClass().getName());
        }
        System.out.println();
        System.out.println("Invoking greetMeOneWay...");
        port.greetMeOneWay(System.getProperty("user.name"));
        System.out.println("No response from server as method is OneWay");
        System.out.println();
        try {
            System.out.println("Invoking pingMe, expecting exception...");
            port.pingMe("hello");
        }
        catch (PingMeFault ex) {
            System.out.println("Expected exception: PingMeFault has occurred: " + ex.getMessage());
            FaultDetail detail = ex.getFaultInfo();
            System.out.println("FaultDetail major:" + detail.getMajor());
            System.out.println("FaultDetail minor:" + detail.getMinor());
        }
    }
}

