/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.ReflectionInjector;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConverterTest
extends TestCase {
    private static final transient Log LOG = LogFactory.getLog(ConverterTest.class);
    protected TypeConverter converter = new DefaultTypeConverter(new ReflectionInjector());

    public void testIntegerPropertyEditorConversion() throws Exception {
        Integer value = this.converter.convertTo(Integer.class, "1000");
        ConverterTest.assertNotNull((Object)value);
        ConverterTest.assertEquals((String)"Converted to Integer", (Object)new Integer(1000), (Object)value);
        String text = this.converter.convertTo(String.class, value);
        ConverterTest.assertEquals((String)"Converted to String", (String)"1000", (String)text);
    }

    public void testConvertStringToAndFromByteArray() throws Exception {
        byte[] array = this.converter.convertTo(byte[].class, "foo");
        ConverterTest.assertNotNull((Object)array);
        LOG.debug((Object)("Found array of size: " + array.length));
        String text = this.converter.convertTo(String.class, array);
        ConverterTest.assertEquals((String)"Converted to String", (String)"foo", (String)text);
    }

    public void testConvertStringToAndFromCharArray() throws Exception {
        char[] array = this.converter.convertTo(char[].class, "foo");
        ConverterTest.assertNotNull((Object)array);
        LOG.debug((Object)("Found array of size: " + array.length));
        String text = this.converter.convertTo(String.class, array);
        ConverterTest.assertEquals((String)"Converted to String", (String)"foo", (String)text);
    }

    public void testConvertStringAndStreams() throws Exception {
        InputStream inputStream = this.converter.convertTo(InputStream.class, "bar");
        ConverterTest.assertNotNull((Object)inputStream);
        String text = this.converter.convertTo(String.class, inputStream);
        ConverterTest.assertEquals((String)"Converted to String", (String)"bar", (String)text);
    }

    public void testArrayToListAndSetConversion() throws Exception {
        String[] array = new String[]{"one", "two"};
        List list = this.converter.convertTo(List.class, array);
        ConverterTest.assertEquals((String)("List size: " + list), (int)2, (int)list.size());
        Collection collection = this.converter.convertTo(Collection.class, array);
        ConverterTest.assertEquals((String)("Collection size: " + collection), (int)2, (int)collection.size());
        Set set = this.converter.convertTo(Set.class, array);
        ConverterTest.assertEquals((String)("Set size: " + set), (int)2, (int)set.size());
        set = this.converter.convertTo(Set.class, list);
        ConverterTest.assertEquals((String)("Set size: " + set), (int)2, (int)set.size());
    }

    public void testCollectionToArrayConversion() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        Object[] objectArray = this.converter.convertTo(Object[].class, list);
        ConverterTest.assertEquals((String)"Object[] length", (int)2, (int)objectArray.length);
        String[] stringArray = this.converter.convertTo(String[].class, list);
        ConverterTest.assertEquals((String)"String[] length", (int)2, (int)stringArray.length);
    }

    public void testCollectionToPrimitiveArrayConversion() throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(5);
        list.add(6);
        Integer[] integerArray = this.converter.convertTo(Integer[].class, list);
        ConverterTest.assertEquals((String)"Integer[] length", (int)2, (int)integerArray.length);
        int[] intArray = this.converter.convertTo(int[].class, list);
        ConverterTest.assertEquals((String)"int[] length", (int)2, (int)intArray.length);
        long[] longArray = this.converter.convertTo(long[].class, intArray);
        ConverterTest.assertEquals((String)"long[] length", (int)2, (int)longArray.length);
        List resultList = this.converter.convertTo(List.class, intArray);
        ConverterTest.assertEquals((String)"List size", (int)2, (int)resultList.size());
        LOG.debug((Object)("From primitive type array we've created the list: " + resultList));
    }

    public void testStringToFile() throws Exception {
        File file = this.converter.convertTo(File.class, "foo.txt");
        ConverterTest.assertNotNull((Object)"Should have converted to a file!");
        ConverterTest.assertEquals((String)"file name", (String)"foo.txt", (String)file.getName());
    }

    public void testFileToString() throws Exception {
        URL resource = ((Object)((Object)this)).getClass().getResource("dummy.txt");
        ConverterTest.assertNotNull((Object)"Cannot find resource!");
        File file = new File(resource.getFile());
        String text = this.converter.convertTo(String.class, file);
        ConverterTest.assertNotNull((String)"Should have returned a String!", (Object)text);
        text = text.trim();
        ConverterTest.assertTrue((String)("Text not read correctly: " + text), (boolean)text.endsWith("Hello World!"));
    }

    public void testPrimitiveBooleanConversion() throws Exception {
        boolean value = this.converter.convertTo(Boolean.TYPE, null);
        ConverterTest.assertFalse((boolean)value);
    }

    public void testPrimitiveIntConversion() throws Exception {
        int value = this.converter.convertTo(Integer.TYPE, 4);
        ConverterTest.assertEquals((String)"value", (int)4, (int)value);
    }

    public void testPrimitiveIntPropertySetter() throws Exception {
        MyBean bean = new MyBean();
        IntrospectionSupport.setProperty(this.converter, bean, "foo", "4");
        ConverterTest.assertEquals((String)"bean.foo", (int)4, (int)bean.getFoo());
    }

    public void testStringToBoolean() throws Exception {
        Boolean value = this.converter.convertTo(Boolean.class, "true");
        ConverterTest.assertEquals((String)"converted boolean value", (Object)Boolean.TRUE, (Object)value);
        value = this.converter.convertTo(Boolean.class, "false");
        ConverterTest.assertEquals((String)"converted boolean value", (Object)Boolean.FALSE, (Object)value);
        value = this.converter.convertTo(Boolean.class, null);
        ConverterTest.assertEquals((String)"converted boolean value", null, (Object)value);
    }

    protected void setUp() throws Exception {
        PropertyEditorManager.registerEditor(Integer.class, IntegerPropertyEditor.class);
    }

    public static class MyBean {
        private int foo;

        public int getFoo() {
            return this.foo;
        }

        public void setFoo(int foo) {
            this.foo = foo;
        }
    }

    public static class IntegerPropertyEditor
    extends PropertyEditorSupport {
        public void setAsText(String text) throws IllegalArgumentException {
            this.setValue(new Integer(text));
        }

        public String getAsText() {
            Integer value = (Integer)this.getValue();
            return value != null ? value.toString() : "";
        }
    }
}

