/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.xslt.TestBean;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class XsltRouteTest
extends SpringTestSupport {
    public void testSendMessageAndHaveItTransformed() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<mail><subject>Hey</subject><body>Hello world!</body></mail>");
        this.assertMockEndpointsSatisifed();
        List<Exchange> list = endpoint.getReceivedExchanges();
        Exchange exchange = list.get(0);
        String xml = exchange.getIn().getBody(String.class);
        this.log.debug((Object)("Found: " + xml));
        TestBean bean = this.getMandatoryBean(TestBean.class, "testBean");
        XsltRouteTest.assertEquals((String)"bean.subject", (String)"Hey", (String)bean.getSubject());
        this.log.debug((Object)("Found bean subject: " + bean.getSubject()));
    }

    protected int getExpectedRouteCount() {
        return 0;
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/component/xslt/camelContext.xml");
    }
}

