/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.test;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.test.TestEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class TestEndpointTest
extends AbstractJUnit38SpringContextTests {
    private static final transient Log LOG = LogFactory.getLog(TestEndpointTest.class);
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="test:file://src/test/data?noop=true")
    protected TestEndpoint endpoint;

    public void testMocksAreValid() throws Exception {
        TestEndpointTest.assertNotNull((Object)this.camelContext);
        TestEndpointTest.assertNotNull((Object)this.endpoint);
        MockEndpoint.assertIsSatisfied(this.camelContext);
        List<MockEndpoint> list = CamelContextHelper.getSingletonEndpoints(this.camelContext, MockEndpoint.class);
        LOG.debug((Object)("Found endpoints: " + list));
        List<Exchange> exchanges = this.endpoint.getReceivedExchanges();
        for (Exchange exchange : exchanges) {
            LOG.debug((Object)("Received: " + exchange));
        }
    }
}

