/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rmi;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanExchange;
import org.apache.camel.component.rmi.RmiComponent;
import org.apache.camel.component.rmi.RmiConsumer;
import org.apache.camel.component.rmi.RmiProducer;
import org.apache.camel.impl.DefaultEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmiEndpoint
extends DefaultEndpoint<BeanExchange> {
    private List<Class> remoteInterfaces;
    private ClassLoader classLoader;
    private URI uri;
    private int port;
    private String method;

    protected RmiEndpoint(String endpointUri, RmiComponent component) throws URISyntaxException {
        super(endpointUri, component);
        this.uri = new URI(endpointUri);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public BeanExchange createExchange(ExchangePattern pattern) {
        return new BeanExchange(this.getContext(), pattern);
    }

    @Override
    public Consumer<BeanExchange> createConsumer(Processor processor) throws Exception {
        if (this.remoteInterfaces == null || this.remoteInterfaces.size() == 0) {
            throw new RuntimeCamelException("To create an RMI consumer, the RMI endpoint's remoteInterfaces property must be be configured.");
        }
        return new RmiConsumer(this, processor);
    }

    @Override
    public Producer<BeanExchange> createProducer() throws Exception {
        return new RmiProducer(this);
    }

    public String getName() {
        String path = this.uri.getPath();
        if (path == null) {
            path = this.uri.getSchemeSpecificPart();
        }
        return path;
    }

    public Registry getRegistry() throws RemoteException {
        if (this.uri.getHost() != null) {
            if (this.uri.getPort() == -1) {
                return LocateRegistry.getRegistry(this.uri.getHost());
            }
            return LocateRegistry.getRegistry(this.uri.getHost(), this.uri.getPort());
        }
        return LocateRegistry.getRegistry();
    }

    public List<Class> getRemoteInterfaces() {
        return this.remoteInterfaces;
    }

    public void setRemoteInterfaces(List<Class> remoteInterfaces) {
        this.remoteInterfaces = remoteInterfaces;
        if (this.classLoader == null && !remoteInterfaces.isEmpty()) {
            this.classLoader = remoteInterfaces.get(0).getClassLoader();
        }
    }

    public void setRemoteInterfaces(Class ... remoteInterfaces) {
        this.setRemoteInterfaces(Arrays.asList(remoteInterfaces));
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

