/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class MockEndpointTest
extends ContextTestSupport {
    public void testAscendingMessagesPass() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsAscending(this.header("counter").convertTo(Number.class));
        this.sendMessages(11, 12, 13, 14, 15);
        resultEndpoint.assertIsSatisfied();
    }

    public void testAscendingMessagesFail() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsAscending(this.header("counter").convertTo(Number.class));
        this.sendMessages(11, 12, 13, 15, 14);
        resultEndpoint.assertIsNotSatisfied();
    }

    public void testDescendingMessagesPass() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsDescending(this.header("counter").convertTo(Number.class));
        this.sendMessages(15, 14, 13, 12, 11);
        resultEndpoint.assertIsSatisfied();
    }

    public void testDescendingMessagesFail() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsDescending(this.header("counter").convertTo(Number.class));
        this.sendMessages(15, 14, 13, 11, 12);
        resultEndpoint.assertIsNotSatisfied();
    }

    public void testNoDuplicateMessagesPass() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsNoDuplicates(this.header("counter"));
        this.sendMessages(11, 12, 13, 14, 15);
        resultEndpoint.assertIsSatisfied();
    }

    public void testDuplicateMessagesFail() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsNoDuplicates(this.header("counter"));
        this.sendMessages(11, 12, 13, 14, 12);
        resultEndpoint.assertIsNotSatisfied();
    }

    public void testExpectationsAfterMessagesArrivePass() throws Exception {
        this.sendMessages(11, 12, 13, 14, 12);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(5);
        resultEndpoint.assertIsNotSatisfied();
    }

    public void testExpectationsAfterMessagesArriveFail() throws Exception {
        this.sendMessages(11, 12, 13, 14, 12);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(6);
        resultEndpoint.assertIsNotSatisfied();
    }

    public void testReset() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(2);
        this.sendMessages(11, 12);
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedMessageCount(3);
        this.sendMessages(11, 12, 13);
        resultEndpoint.assertIsSatisfied();
    }

    public void testExpectationOfHeader() throws InterruptedException {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header", "value");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header", "value1");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsNotSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header1", "value");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsNotSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header1", "value1");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsNotSatisfied();
    }

    protected void sendMessages(int ... counters) {
        for (int counter : counters) {
            this.template.sendBodyAndHeader("direct:a", (Object)("<message>" + counter + "</message>"), "counter", (Object)counter);
        }
    }

    protected void sendHeader(String name, String value) {
        this.template.sendBodyAndHeader("direct:a", (Object)"body", name, (Object)value);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").to("mock:result");
            }
        };
    }
}

