/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;

public class MinaPayloadHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object inBody;
    private Object outBody;
    private Map<String, Object> inHeaders = new LinkedHashMap<String, Object>();
    private Map<String, Object> outHeaders = new LinkedHashMap<String, Object>();
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private Throwable exception;

    public static MinaPayloadHolder marshal(Exchange exchange) {
        MinaPayloadHolder payload = new MinaPayloadHolder();
        payload.inBody = exchange.getIn().getBody();
        if (exchange.getOut(false) != null) {
            payload.outBody = exchange.getOut().getBody();
        }
        payload.inHeaders.putAll(exchange.getIn().getHeaders());
        payload.outHeaders.putAll(exchange.getOut().getHeaders());
        payload.properties.putAll(exchange.getProperties());
        payload.exception = exchange.getException();
        return payload;
    }

    public static void unmarshal(Exchange exchange, MinaPayloadHolder payload) {
        exchange.getIn().setBody(payload.inBody);
        exchange.getOut().setBody(payload.outBody);
        exchange.getIn().setHeaders(payload.inHeaders);
        exchange.getOut().setHeaders(payload.outHeaders);
        for (String key : payload.properties.keySet()) {
            exchange.setProperty(key, payload.properties.get(key));
        }
        exchange.setException(payload.exception);
    }

    public String toString() {
        return "MinaPayloadHolder{inBody=" + this.inBody + ", outBody=" + this.outBody + ", inHeaders=" + this.inHeaders + ", outHeaders=" + this.outHeaders + ", properties=" + this.properties + ", exception=" + this.exception + '}';
    }
}

