/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mina.MinaComponent;
import org.apache.camel.component.mina.MinaConsumer;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.component.mina.MinaPayloadHelper;
import org.apache.camel.component.mina.MinaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaEndpoint
extends DefaultEndpoint<MinaExchange> {
    private static final long DEFAULT_TIMEOUT = 30000L;
    private long timeout = 30000L;
    private final IoAcceptor acceptor;
    private final SocketAddress address;
    private final IoConnector connector;
    private final IoAcceptorConfig acceptorConfig;
    private final IoConnectorConfig connectorConfig;
    private final boolean lazySessionCreation;
    private final boolean transferExchange;

    public MinaEndpoint(String endpointUri, MinaComponent component, SocketAddress address, IoAcceptor acceptor, IoAcceptorConfig acceptorConfig, IoConnector connector, IoConnectorConfig connectorConfig, boolean lazySessionCreation, long timeout, boolean transferExchange) {
        super(endpointUri, component);
        this.address = address;
        this.acceptor = acceptor;
        this.acceptorConfig = acceptorConfig;
        this.connectorConfig = connectorConfig;
        this.connector = connector;
        this.lazySessionCreation = lazySessionCreation;
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.transferExchange = transferExchange;
    }

    @Override
    public Producer<MinaExchange> createProducer() throws Exception {
        return new MinaProducer(this);
    }

    @Override
    public Consumer<MinaExchange> createConsumer(Processor processor) throws Exception {
        return new MinaConsumer(this, processor);
    }

    @Override
    public MinaExchange createExchange(ExchangePattern pattern) {
        return new MinaExchange(this.getContext(), pattern, null);
    }

    public MinaExchange createExchange(IoSession session, Object payload) {
        MinaExchange exchange = new MinaExchange(this.getContext(), this.getExchangePattern(), session);
        MinaPayloadHelper.setIn(exchange, payload);
        return exchange;
    }

    public IoAcceptor getAcceptor() {
        return this.acceptor;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public IoConnector getConnector() {
        return this.connector;
    }

    public boolean isLazySessionCreation() {
        return this.lazySessionCreation;
    }

    public IoAcceptorConfig getAcceptorConfig() {
        return this.acceptorConfig;
    }

    public IoConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }
}

