/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.list;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(ListTest.class);
    protected Object body1 = "one";
    protected Object body2 = "two";

    public void testListEndpoints() throws Exception {
        this.template.sendBody("list:foo", this.body1);
        this.template.sendBody("list:foo", this.body2);
        List<BrowsableEndpoint> list = CamelContextHelper.getSingletonEndpoints(this.context, BrowsableEndpoint.class);
        ListTest.assertEquals((String)"number of endpoints", (int)2, (int)list.size());
        Thread.sleep(2000L);
        for (BrowsableEndpoint endpoint : list) {
            List<Exchange> exchanges = endpoint.getExchanges();
            LOG.debug((Object)(">>>> " + endpoint + " has: " + exchanges));
            ListTest.assertEquals((String)("Exchanges received on " + endpoint), (int)2, (int)exchanges.size());
            this.assertInMessageBodyEquals(exchanges.get(0), this.body1);
            this.assertInMessageBodyEquals(exchanges.get(1), this.body2);
        }
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("list:foo").to("list:bar");
            }
        };
    }
}

