/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.lang.reflect.Method;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jpa.Consumed;
import org.apache.camel.component.jpa.DeleteHandler;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.QueryBuilder;
import org.apache.camel.component.jpa.QueryFactory;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.JpaCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaConsumer
extends ScheduledPollConsumer<Exchange> {
    private static final transient Log LOG = LogFactory.getLog(JpaConsumer.class);
    private final JpaEndpoint endpoint;
    private final TransactionStrategy template;
    private QueryFactory queryFactory;
    private DeleteHandler<Object> deleteHandler;
    private String query;
    private String namedQuery;
    private String nativeQuery;

    public JpaConsumer(JpaEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.template = endpoint.createTransactionStrategy();
    }

    @Override
    protected void poll() throws Exception {
        this.template.execute(new JpaCallback(){

            public Object doInJpa(EntityManager entityManager) throws PersistenceException {
                Query query = JpaConsumer.this.getQueryFactory().createQuery(entityManager);
                JpaConsumer.this.configureParameters(query);
                List results = query.getResultList();
                for (Object result : results) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Processing new entity: " + result));
                    }
                    if (!JpaConsumer.this.lockEntity(result, entityManager)) continue;
                    Exchange exchange = JpaConsumer.this.createExchange(result);
                    try {
                        JpaConsumer.this.getProcessor().process(exchange);
                    }
                    catch (Exception e) {
                        throw new PersistenceException((Throwable)e);
                    }
                    JpaConsumer.this.getDeleteHandler().deleteObject(entityManager, result);
                }
                entityManager.flush();
                return null;
            }
        });
    }

    public JpaEndpoint getEndpoint() {
        return this.endpoint;
    }

    public QueryFactory getQueryFactory() {
        if (this.queryFactory == null) {
            this.queryFactory = this.createQueryFactory();
            if (this.queryFactory == null) {
                throw new IllegalArgumentException("No queryType property configured on this consumer, nor an entityType configured on the endpoint so cannot consume");
            }
        }
        return this.queryFactory;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public DeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = this.createDeleteHandler();
        }
        return this.deleteHandler;
    }

    public void setDeleteHandler(DeleteHandler deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    protected boolean lockEntity(Object entity, EntityManager entityManager) {
        if (!this.getEndpoint().isConsumeDelete() || !this.getEndpoint().isConsumeLockEntity()) {
            return true;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Acquiring exclusive lock on entity: " + entity));
            }
            entityManager.lock(entity, LockModeType.WRITE);
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to achieve lock on entity: " + entity + ". Reason: " + e), (Throwable)e);
            }
            return false;
        }
    }

    protected QueryFactory createQueryFactory() {
        if (this.query != null) {
            return QueryBuilder.query(this.query);
        }
        if (this.namedQuery != null) {
            return QueryBuilder.namedQuery(this.namedQuery);
        }
        if (this.nativeQuery != null) {
            return QueryBuilder.nativeQuery(this.nativeQuery);
        }
        Class<?> entityType = this.endpoint.getEntityType();
        if (entityType == null) {
            return null;
        }
        return QueryBuilder.query("select x from " + entityType.getName() + " x");
    }

    protected DeleteHandler<Object> createDeleteHandler() {
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType != null) {
            List<Method> methods = ObjectHelper.findMethodsWithAnnotation(entityType, Consumed.class);
            if (methods.size() > 1) {
                throw new IllegalArgumentException("Only one method can be annotated with the @Consumed annotation but found: " + methods);
            }
            if (methods.size() == 1) {
                final Method method = methods.get(0);
                return new DeleteHandler<Object>(){

                    @Override
                    public void deleteObject(EntityManager entityManager, Object entityBean) {
                        ObjectHelper.invokeMethod(method, entityBean, new Object[0]);
                    }
                };
            }
        }
        if (this.getEndpoint().isConsumeDelete()) {
            return new DeleteHandler<Object>(){

                @Override
                public void deleteObject(EntityManager entityManager, Object entityBean) {
                    entityManager.remove(entityBean);
                }
            };
        }
        return new DeleteHandler<Object>(){

            @Override
            public void deleteObject(EntityManager entityManager, Object entityBean) {
            }
        };
    }

    protected void configureParameters(Query query) {
        int maxResults = this.endpoint.getMaximumResults();
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
    }

    protected Exchange createExchange(Object result) {
        Object exchange = this.endpoint.createExchange();
        exchange.getIn().setBody(result);
        return exchange;
    }
}

