/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.requestor;

import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.requestor.FailedToProcessResponse;
import org.apache.camel.component.jms.requestor.FutureHandler;
import org.apache.camel.component.jms.requestor.ReplyHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.DefaultTimeoutMap;
import org.apache.camel.util.TimeoutMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer102;
import org.springframework.jms.support.destination.DestinationResolver;

public class Requestor
extends ServiceSupport
implements MessageListener {
    private static final transient Log LOG = LogFactory.getLog(Requestor.class);
    private final JmsConfiguration configuration;
    private AbstractMessageListenerContainer listenerContainer;
    private TimeoutMap requestMap;
    private Destination replyTo;

    public Requestor(JmsConfiguration configuration, ScheduledExecutorService executorService) {
        this.configuration = configuration;
        this.requestMap = new DefaultTimeoutMap(executorService, configuration.getRequestMapPurgePollTimeMillis());
    }

    public FutureTask getReceiveFuture(String correlationID, long requestTimeout) {
        FutureHandler future = null;
        if (future == null) {
            FutureHandler futureHandler;
            future = futureHandler = new FutureHandler();
            this.requestMap.put(correlationID, futureHandler, requestTimeout);
        }
        return future;
    }

    public void onMessage(Message message) {
        try {
            ReplyHandler replyHandler;
            boolean complete;
            String correlationID = message.getJMSCorrelationID();
            if (correlationID == null) {
                LOG.warn((Object)("Ignoring message with no correlationID! " + message));
                return;
            }
            Object handler = this.requestMap.get(correlationID);
            if (handler == null) {
                LOG.warn((Object)("Response received for unknown correlationID: " + correlationID + " request: " + message));
            } else if (handler instanceof ReplyHandler && (complete = (replyHandler = (ReplyHandler)handler).handle(message))) {
                this.requestMap.remove(correlationID);
            }
        }
        catch (JMSException e) {
            throw new FailedToProcessResponse(message, e);
        }
    }

    public AbstractMessageListenerContainer getListenerContainer() {
        if (this.listenerContainer == null) {
            this.listenerContainer = this.createListenerContainer();
        }
        return this.listenerContainer;
    }

    public void setListenerContainer(AbstractMessageListenerContainer listenerContainer) {
        this.listenerContainer = listenerContainer;
    }

    public Destination getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(Destination replyTo) {
        this.replyTo = replyTo;
    }

    protected void doStart() throws Exception {
        AbstractMessageListenerContainer container = this.getListenerContainer();
        container.afterPropertiesSet();
    }

    protected void doStop() throws Exception {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
            this.listenerContainer.destroy();
        }
    }

    protected AbstractMessageListenerContainer createListenerContainer() {
        ExceptionListener exceptionListener;
        TaskExecutor taskExecutor;
        SimpleMessageListenerContainer102 answer = this.configuration.isUseVersion102() ? new SimpleMessageListenerContainer102() : new SimpleMessageListenerContainer();
        answer.setDestinationName("temporary");
        answer.setDestinationResolver(new DestinationResolver(){

            public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
                TemporaryQueue queue = session.createTemporaryQueue();
                Requestor.this.replyTo = (Destination)queue;
                return queue;
            }
        });
        answer.setAutoStartup(true);
        answer.setMessageListener((Object)this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(1);
        answer.setConnectionFactory(this.configuration.getConnectionFactory());
        String clientId = this.configuration.getClientId();
        if (clientId != null) {
            clientId = clientId + ".Requestor";
            answer.setClientId(clientId);
        }
        if ((taskExecutor = this.configuration.getTaskExecutor()) != null) {
            answer.setTaskExecutor(taskExecutor);
        }
        if ((exceptionListener = this.configuration.getExceptionListener()) != null) {
            answer.setExceptionListener(exceptionListener);
        }
        return answer;
    }
}

