/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsExchange;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.spi.BrowsableEndpoint;
import org.springframework.jms.core.JmsOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsQueueEndpoint
extends JmsEndpoint
implements BrowsableEndpoint<JmsExchange> {
    private int maximumBrowseSize = -1;
    private final QueueBrowseStrategy queueBrowseStrategy;

    public JmsQueueEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration) {
        this(uri, component, destination, configuration, JmsQueueEndpoint.createQueueBrowseStrategy());
    }

    public JmsQueueEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        super(uri, component, destination, false, configuration);
        this.queueBrowseStrategy = queueBrowseStrategy;
    }

    public int getMaximumBrowseSize() {
        return this.maximumBrowseSize;
    }

    public void setMaximumBrowseSize(int maximumBrowseSize) {
        this.maximumBrowseSize = maximumBrowseSize;
    }

    @Override
    public List<Exchange> getExchanges() {
        String queue = this.getDestination();
        JmsOperations template = this.getConfiguration().createInOnlyTemplate(false, queue);
        return this.queueBrowseStrategy.browse(template, queue, this);
    }

    protected static QueueBrowseStrategy createQueueBrowseStrategy() {
        QueueBrowseStrategy answer = null;
        try {
            answer = JmsComponent.tryCreateDefaultQueueBrowseStrategy();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not create a QueueBrowseStrategy, maybe you are using spring 2.0.x? Cause: " + e, e);
        }
        if (answer == null) {
            throw new IllegalArgumentException("Could not create a QueueBrowseStrategy, maybe you are using spring 2.0.x?");
        }
        return answer;
    }
}

