/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.requestor.Requestor;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.UuidGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;

public class JmsProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(JmsProducer.class);
    private final JmsEndpoint endpoint;
    private JmsOperations inOnlyTemplate;
    private JmsOperations inOutTemplate;
    private UuidGenerator uuidGenerator;

    public JmsProducer(JmsEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public void process(final Exchange exchange) {
        block13: {
            final Message in = exchange.getIn();
            if (exchange.getPattern().isOutCapable()) {
                Requestor requestor;
                try {
                    requestor = this.endpoint.getRequestor();
                }
                catch (Exception e) {
                    throw new RuntimeExchangeException(e, exchange);
                }
                final Destination replyTo = requestor.getReplyTo();
                String correlationId = in.getHeader("JMSCorrelationID", String.class);
                if (correlationId == null) {
                    correlationId = this.getUuidGenerator().generateId();
                    in.setHeader("JMSCorrelationID", correlationId);
                }
                long requestTimeout = this.endpoint.getRequestTimeout();
                FutureTask future = requestor.getReceiveFuture(correlationId, requestTimeout);
                this.getInOutTemplate().send(this.endpoint.getDestination(), new MessageCreator(){

                    public javax.jms.Message createMessage(Session session) throws JMSException {
                        javax.jms.Message message = JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session);
                        message.setJMSReplyTo(replyTo);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(JmsProducer.this.endpoint + " sending JMS message: " + message));
                        }
                        return message;
                    }
                });
                try {
                    javax.jms.Message message;
                    block12: {
                        message = null;
                        try {
                            message = requestTimeout < 0L ? (javax.jms.Message)future.get() : (javax.jms.Message)future.get(requestTimeout, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Future interupted: " + e), (Throwable)e);
                            }
                        }
                        catch (TimeoutException e) {
                            if (!LOG.isDebugEnabled()) break block12;
                            LOG.debug((Object)("Future timed out: " + e), (Throwable)e);
                        }
                    }
                    if (message != null) {
                        exchange.setOut(new JmsMessage(message, this.endpoint.getBinding()));
                        break block13;
                    }
                    exchange.setException(new ExchangeTimedOutException(exchange, requestTimeout));
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
            } else {
                this.getInOnlyTemplate().send(this.endpoint.getDestination(), new MessageCreator(){

                    public javax.jms.Message createMessage(Session session) throws JMSException {
                        javax.jms.Message message = JmsProducer.this.endpoint.getBinding().makeJmsMessage(exchange, in, session);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(JmsProducer.this.endpoint + " sending JMS message: " + message));
                        }
                        return message;
                    }
                });
            }
        }
    }

    public JmsOperations getTemplate() {
        return this.getInOnlyTemplate();
    }

    public JmsOperations getInOnlyTemplate() {
        if (this.inOnlyTemplate == null) {
            this.inOnlyTemplate = this.endpoint.createInOnlyTemplate();
        }
        return this.inOnlyTemplate;
    }

    public void setInOnlyTemplate(JmsOperations inOnlyTemplate) {
        this.inOnlyTemplate = inOnlyTemplate;
    }

    public JmsOperations getInOutTemplate() {
        if (this.inOutTemplate == null) {
            this.inOutTemplate = this.endpoint.createInOutTemplate();
        }
        return this.inOutTemplate;
    }

    public void setInOutTemplate(JmsOperations inOutTemplate) {
        this.inOutTemplate = inOutTemplate;
    }

    public UuidGenerator getUuidGenerator() {
        if (this.uuidGenerator == null) {
            this.uuidGenerator = new UuidGenerator();
        }
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }
}

