/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jhc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.camel.component.jhc.AsyncBufferingHttpServiceHandler;
import org.apache.camel.component.jhc.AsyncHttpRequestHandler;
import org.apache.camel.component.jhc.DefaultListeningIOReactor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.DefaultServerIOEventDispatch;
import org.apache.http.impl.nio.reactor.SSLServerIOEventDispatch;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.util.concurrent.ThreadFactory;

public class JhcServerEngine {
    private static final Log LOG = LogFactory.getLog(JhcServerEngine.class);
    private final HttpParams params;
    private int port;
    private String protocol;
    private int nbThreads = 2;
    private ListeningIOReactor ioReactor;
    private ThreadFactory threadFactory;
    private Thread runner;
    private SSLContext sslContext;
    private AsyncBufferingHttpServiceHandler serviceHandler;
    private HttpRequestHandlerRegistry handlerRegistry;
    private boolean isStarted;
    private int referenceCounter;

    JhcServerEngine(HttpParams params, int port, String protocol) {
        this.params = params;
        this.serviceHandler = new AsyncBufferingHttpServiceHandler(params);
        this.handlerRegistry = new HttpRequestHandlerRegistry();
        this.serviceHandler.setHandlerResolver((HttpRequestHandlerResolver)this.handlerRegistry);
        this.port = port;
        this.protocol = protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public synchronized void register(String pattern, AsyncHttpRequestHandler handler) {
        this.handlerRegistry.register(pattern, (HttpRequestHandler)handler);
        ++this.referenceCounter;
    }

    public synchronized void unregister(String pattern) {
        this.handlerRegistry.unregister(pattern);
        --this.referenceCounter;
    }

    public int getReferenceCounter() {
        return this.referenceCounter;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void start() throws IOReactorException {
        final InetSocketAddress addr = new InetSocketAddress(this.port);
        this.ioReactor = new DefaultListeningIOReactor(this.nbThreads, this.threadFactory, this.params);
        Object ioEventDispatch = "https".equals(this.protocol) ? new SSLServerIOEventDispatch((NHttpServiceHandler)this.serviceHandler, this.sslContext, this.params) : new DefaultServerIOEventDispatch((NHttpServiceHandler)this.serviceHandler, this.params);
        this.runner = new Thread((IOEventDispatch)ioEventDispatch){
            final /* synthetic */ IOEventDispatch val$ioEventDispatch;
            {
                this.val$ioEventDispatch = iOEventDispatch;
            }

            public void run() {
                try {
                    JhcServerEngine.this.ioReactor.listen(addr);
                    JhcServerEngine.this.isStarted = true;
                    JhcServerEngine.this.ioReactor.execute(this.val$ioEventDispatch);
                }
                catch (InterruptedIOException ex) {
                    LOG.info((Object)"Interrupted");
                }
                catch (IOException e) {
                    LOG.warn((Object)("I/O error: " + e.getMessage()));
                }
                LOG.debug((Object)"Shutdown");
            }
        };
        this.runner.start();
    }

    public void stop() throws IOException {
        LOG.debug((Object)"Stopping the jhc ioReactor ");
        this.ioReactor.shutdown();
        LOG.debug((Object)"Waiting the runner");
        try {
            this.runner.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.isStarted = false;
        LOG.debug((Object)"Runner stopped");
    }
}

