/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jhc;

import java.net.URI;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jhc.JhcComponent;
import org.apache.camel.component.jhc.JhcConsumer;
import org.apache.camel.component.jhc.JhcExchange;
import org.apache.camel.component.jhc.JhcProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JhcEndpoint
extends DefaultEndpoint<JhcExchange> {
    private HttpParams params;
    private URI httpUri;

    public JhcEndpoint(String endpointUri, JhcComponent component, URI httpUri) {
        super(endpointUri, component);
        this.params = new BasicHttpParams(component.getParams());
        this.httpUri = httpUri;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setParams(HttpParams params) {
        this.params = params;
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public void setHttpUri(URI httpUri) {
        this.httpUri = httpUri;
    }

    public String getProtocol() {
        return this.httpUri.getScheme();
    }

    public String getHost() {
        return this.httpUri.getHost();
    }

    public int getPort() {
        if (this.httpUri.getPort() == -1) {
            if ("https".equals(this.getProtocol())) {
                return 443;
            }
            return 80;
        }
        return this.httpUri.getPort();
    }

    public String getPath() {
        return this.httpUri.getPath();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Producer<JhcExchange> createProducer() throws Exception {
        return new JhcProducer(this);
    }

    @Override
    public Consumer<JhcExchange> createConsumer(Processor processor) throws Exception {
        return new JhcConsumer(this, processor);
    }
}

