/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jhc;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.camel.Converter;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

@Converter
public final class JhcConverter {
    private JhcConverter() {
    }

    @Converter
    public static InputStream toInputStream(HttpEntity entity) throws IOException {
        return entity.getContent();
    }

    @Converter
    public static byte[] toByteArray(HttpEntity entity) throws IOException {
        return EntityUtils.toByteArray((HttpEntity)entity);
    }

    @Converter
    public static String toString(HttpEntity entity) throws IOException {
        return EntityUtils.toString((HttpEntity)entity);
    }

    @Converter
    public static HttpEntity toEntity(InputStream is) {
        return new InputStreamEntity(is, -1L);
    }

    @Converter
    public static HttpEntity toEntity(String str) throws UnsupportedEncodingException {
        return new StringEntity(str);
    }
}

