/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.component.ibatis.IBatisEndpoint;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.DefaultProducer;

public class IBatisProducer
extends DefaultProducer {
    private final IBatisEndpoint endpoint;

    public IBatisProducer(IBatisEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public IBatisEndpoint getEndpoint() {
        return (IBatisEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        Object body = exchange.getIn().getBody();
        if (body == null) {
            this.endpoint.query(exchange.getOut(true));
        } else {
            String operation = this.getOperationName(exchange);
            Iterator iter = ObjectConverter.iterator(body);
            while (iter.hasNext()) {
                this.endpoint.getSqlClient().insert(operation, iter.next());
            }
        }
    }

    protected String getOperationName(Exchange exchange) {
        return this.endpoint.getEntityName();
    }
}

