/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProducer
extends DefaultProducer<HttpExchange>
implements Producer<HttpExchange> {
    public static final String HTTP_RESPONSE_CODE = "http.responseCode";
    public static final String QUERY = "org.apache.camel.component.http.query";
    private HttpClient httpClient;

    public HttpProducer(HttpEndpoint endpoint) {
        super(endpoint);
        this.httpClient = endpoint.createHttpClient();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Header[] headers;
        HttpMethod method = this.createMethod(exchange);
        HttpBinding binding = ((HttpEndpoint)this.getEndpoint()).getBinding();
        for (String headerName : exchange.getIn().getHeaders().keySet()) {
            String headerValue;
            if (!binding.shouldHeaderBePropagated(headerName, headerValue = exchange.getIn().getHeader(headerName, String.class))) continue;
            method.addRequestHeader(headerName, headerValue);
        }
        int responseCode = this.httpClient.executeMethod(method);
        InputStream in = method.getResponseBodyAsStream();
        Message out = exchange.getOut(true);
        out.setBody(in);
        for (Header header : headers = method.getResponseHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            out.setHeader(name, value);
        }
        out.setHeader(HTTP_RESPONSE_CODE, responseCode);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpMethod createMethod(Exchange exchange) {
        String uri = ((HttpEndpoint)this.getEndpoint()).getHttpUri().toString();
        RequestEntity requestEntity = this.createRequestEntity(exchange);
        if (requestEntity == null) {
            GetMethod method = new GetMethod(uri);
            if (exchange.getIn().getHeader(QUERY) != null) {
                method.setQueryString(exchange.getIn().getHeader(QUERY, String.class));
            }
            return method;
        }
        PostMethod method = new PostMethod(uri);
        method.setRequestEntity(requestEntity);
        return method;
    }

    protected RequestEntity createRequestEntity(Exchange exchange) {
        Message in = exchange.getIn();
        RequestEntity entity = in.getBody(RequestEntity.class);
        if (entity == null) {
            byte[] data = in.getBody(byte[].class);
            if (data == null) {
                return null;
            }
            String contentType = in.getHeader("Content-Type", String.class);
            if (contentType != null) {
                return new ByteArrayRequestEntity(data, contentType);
            }
            return new ByteArrayRequestEntity(data);
        }
        return entity;
    }
}

